// DepotDiffDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DepotDiff.h"
#include "DepotDiffDlg.h"
#include "AboutDlg.h"
#include "DepotInfo.h"
#include "PickDirDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDepotDiffDlg dialog

CDepotDiffDlg::CDepotDiffDlg(CWnd* pParent /*=NULL*/)
	: cdxCDynamicDialog(CDepotDiffDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDepotDiffDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDepotDiffDlg::DoDataExchange(CDataExchange* pDX)
{
	cdxCDynamicDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDepotDiffDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
    DDX_Control(pDX, IDC_DEPOT_FILES, m_depotFilesList);
    DDX_Control(pDX, IDC_LOCAL_FILES, m_localFilesList);
    DDX_Control(pDX, IDC_DIFFPATH, m_diffPathEdit);
    DDX_Control(pDX, IDC_RECURSIVE, m_recursiveButton);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDepotDiffDlg, cdxCDynamicDialog)
	//{{AFX_MSG_MAP(CDepotDiffDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(NM_RCLICK, IDC_LOCAL_FILES, OnNMRclickLocalFiles)
	ON_NOTIFY(NM_RCLICK, IDC_DEPOT_FILES, OnNMRclickDepotFiles)
	ON_BN_CLICKED(IDC_BROWSE, OnBnClickedBrowse)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LOCAL_FILES, OnKeydownLocalFiles)
	ON_NOTIFY(LVN_KEYDOWN, IDC_DEPOT_FILES, OnKeydownDepotFiles)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DYNAMIC_MAP(CDepotDiffDlg, cdxCDynamicDialog)
	DYNAMIC_MAP_ENTRY(IDC_DIFFPATH,			mdResize,	mdNone)
	DYNAMIC_MAP_ENTRY(IDC_BROWSE,			mdRepos,	mdNone)
	DYNAMIC_MAP_ENTRY(IDOK,					mdRepos,	mdNone)

	DYNAMIC_MAP_ENTRY_EX(IDC_DEPOT_FILES,	0, 0, 50, 100)
	DYNAMIC_MAP_ENTRY_EX(IDC_LOCAL_FILES,	50, 0, 100, 100)
END_DYNAMIC_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDepotDiffDlg message handlers

BOOL CDepotDiffDlg::OnInitDialog()
{
	cdxCDynamicDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_localFilesList.SetListType(CDiffListCtrl::LOCAL_FILES);
	m_localFilesList.SetOtherListCtrl(m_depotFilesList);
	m_depotFilesList.SetListType(CDiffListCtrl::DEPOT_FILES);
	m_depotFilesList.SetOtherListCtrl(m_localFilesList);

	m_localFilesList.InsertColumn(0, "Name", LVCFMT_LEFT, 500);
	m_depotFilesList.InsertColumn(0, "Name", LVCFMT_LEFT, 500);

	DWORD dwStyle = (DWORD)m_localFilesList.SendMessage(LVM_GETEXTENDEDLISTVIEWSTYLE, 0 ,0);
	dwStyle |= LVS_EX_FULLROWSELECT;
	m_localFilesList.SendMessage( LVM_SETEXTENDEDLISTVIEWSTYLE, 0,dwStyle );
	m_depotFilesList.SendMessage( LVM_SETEXTENDEDLISTVIEWSTYLE, 0,dwStyle );

	m_diffPathEdit.SetWindowText(m_rootDirectory);
	m_recursiveButton.SetCheck(m_recursive);

	GetWindowText( m_windowTitle );

	return TRUE;  // return TRUE  unless you set the focus to a control
}



void CDepotDiffDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		cdxCDynamicDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDepotDiffDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		cdxCDynamicDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDepotDiffDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}



void CDepotDiffDlg::Refresh(CString dirName, bool recursive)
{
	m_localFilesList.DeleteAllItems();
	m_depotFilesList.DeleteAllItems();

	FileList& diffFiles = theApp.GetDiffFiles();
	diffFiles.Empty();

	FileInfo dirInfo;
	dirInfo.SetName(dirName);
	dirInfo.SetDirectory(true);
	dirInfo.SetFileOp(FileInfo::SAME);
	diffFiles.Add(dirInfo);

	RefreshRecursive(diffFiles, dirName, recursive);

	SetWindowText( m_windowTitle );

	diffFiles.RemoveFileOp(FileInfo::CHANGELIST_FILE);

	m_localFilesList.SetItemCount(diffFiles.GetCount());
	m_depotFilesList.SetItemCount(diffFiles.GetCount());
}


void CDepotDiffDlg::RefreshRecursive(FileList& toProcessFiles, CString dirName, bool recursive)
{
/*	m_localFilesList.InsertItem(m_localFilesList.GetItemCount(), dirName);

	DepotWhere depotWhere;
	CString depotDirName = depotWhere.Run(theApp.GetClientApi(), dirName);

	m_depotFilesList.InsertItem(m_depotFilesList.GetItemCount(), depotDirName);
*/
	ClientApi& client = theApp.GetClientApi();

	CString str;
	str.Format( "%s - Processing %s", m_windowTitle, dirName );
	SetWindowText( str );

	{
		DepotFileList depotFiles;
		depotFiles.Scan(client, dirName, false);

		LocalFiles localFiles;
		localFiles.Scan(dirName, false);

		// First, grab all the files that are already in the change list.
		AlreadyInChangeListFileList alreadyInChangeList(depotFiles);
		toProcessFiles.Add(alreadyInChangeList, FileInfo::CHANGELIST_FILE);

		// Grab all the files that aren't in the depot.  Add them.
		NonExistentFiles filesNotInDepot(depotFiles, localFiles);
		toProcessFiles.Add(filesNotInDepot, FileInfo::LOCAL_ONLY);

//		AddFileList(m_localFilesList, filesNotInDepot);

		// Now, grab all the files the are in the depot but are writable on the
		// local hard drive.  Edit them.
		WritableFileList writableFiles(localFiles);
		toProcessFiles.Add(writableFiles, FileInfo::WRITABLE);

		// Next, get all the files that are in the depot but aren't on the local
		// hard drive.  Sync them.
		NonExistentFiles filesNotLocal(localFiles, depotFiles);
		toProcessFiles.Add(filesNotLocal, FileInfo::DEPOT_ONLY);

//		AddFileList(m_depotFilesList, filesNotLocal);

		// Finally, sync all the files whose revisions are different.
		RevisionDifferentFileList revisionDifferentFileList(depotFiles);
		toProcessFiles.Add(revisionDifferentFileList, FileInfo::DIFF_REV);

//		toProcessFiles.Print();

//		if (!g_listResultsOnly)
/*		{
			for (int i = 0; i < toProcessFiles.GetCount(); ++i)
			{
				const FileInfo* fileInfo = toProcessFiles.Get(i);
				CString fullPath = fileInfo->GetFullPath();

				if (fileInfo->GetFileOp() == FileInfo::ADD_FILE)
				{
					DepotAdd depotAdd;
					depotAdd.Run(client, fileInfo->GetFullPath());
				}
				else if (fileInfo->GetFileOp() == FileInfo::EDIT_FILE)
				{
					DepotEdit depotEdit;
					depotEdit.Run(client, fileInfo->GetFullPath());
				}
			}
		}
*/
	}

	DepotDirs depotDirs;
	depotDirs.Scan(client, dirName);

	LocalDirs localDirs;
	localDirs.Scan(dirName);

	// First, grab all the directories that aren't in the depot.  Add them.
	NonExistentFiles dirsNotInDepot(depotDirs, localDirs);

	toProcessFiles.Add(dirsNotInDepot, FileInfo::LOCAL_ONLY);

	// Next, get all the directories that are in the depot but aren't on
	// the local hard drive.
	NonExistentFiles dirsNotLocal(localDirs, depotDirs);

	toProcessFiles.Add(dirsNotLocal, FileInfo::DEPOT_ONLY);

//	AddFileList(m_depotFilesList, dirsNotLocal);

//	if (!g_listResultsOnly  &&  recursive)
/*	if (recursive)
	{
		for (int i = 0; i < dirsNotInDepot.GetCount(); ++i)
		{
			const FileInfo* dirInfo = dirsNotInDepot.Get(i);
			printf("Adding directory [%s]\n", dirInfo->GetFullPath());

			DepotAddRecursive depotAdd;
			depotAdd.Run(client, dirInfo->GetFullPath());
		}
	}
*/
	if (recursive)
	{
		for (int i = 0; i < depotDirs.GetCount(); ++i)
		{
			CString dir = depotDirs.Get(i)->GetName();
			dir.TrimRight('\\');

			DepotWhere depotWhere;
			CString newDir = depotWhere.Run(client, dir);

			FileInfo dirInfo;
			dirInfo.SetName(newDir);
			dirInfo.SetDirectory(true);
			dirInfo.SetFileOp(FileInfo::SAME);
			toProcessFiles.Add(dirInfo);

			RefreshRecursive(toProcessFiles, newDir, recursive);
		}
	}
}


void CDepotDiffDlg::RemoveDiffFile(int index)
{
	int item = m_selectedItems[index];
	const FileInfo* fileInfo = theApp.GetDiffFiles()[item];

	FileInfo::FileOp fileOp = fileInfo->GetFileOp();
	if (fileOp == FileInfo::DEPOT_ONLY  ||  fileOp == FileInfo::LOCAL_ONLY  ||
		fileOp == FileInfo::SAME)
	{
		theApp.GetDiffFiles().Remove(item);

		int localFilesCurSel = m_localFilesList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED | LVNI_FOCUSED);
		int depotFilesCurSel = m_depotFilesList.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED | LVNI_FOCUSED);

		if (localFilesCurSel == item)
		{
			if (localFilesCurSel == m_localFilesList.GetItemCount() - 1)
				localFilesCurSel = m_localFilesList.GetItemCount() - 2;
		}

		if (depotFilesCurSel == item)
		{
			if (depotFilesCurSel == m_depotFilesList.GetItemCount() - 1)
				depotFilesCurSel = m_depotFilesList.GetItemCount() - 2;
		}

		m_localFilesList.DeleteItem(item);
		m_depotFilesList.DeleteItem(item);

		if (localFilesCurSel >= 0)
			m_localFilesList.SetItemState(localFilesCurSel, LVNI_FOCUSED, LVNI_FOCUSED);
		if (depotFilesCurSel >= 0)
			m_depotFilesList.SetItemState(depotFilesCurSel, LVNI_FOCUSED, LVNI_FOCUSED);

		// Decrement all remaining values by one, since we just
		// removed something from the list.
		for (int j = index + 1; j < m_selectedItems.GetSize(); ++j)
			m_selectedItems[j] -= 1;
	}
	else
	{
		if (m_activeListType == CDiffListCtrl::DEPOT_FILES)
			ChangeDiffFileOp(item, FileInfo::LOCAL_ONLY);
		else if (m_activeListType == CDiffListCtrl::LOCAL_FILES)
			ChangeDiffFileOp(item, FileInfo::DEPOT_ONLY);
	}
}


void CDepotDiffDlg::ChangeDiffFileOp(int item, FileInfo::FileOp newFileOp)
{
	FileInfo* fileInfo = const_cast<FileInfo*>(theApp.GetDiffFiles()[item]);
	fileInfo->SetFileOp(newFileOp);

	m_localFilesList.Update(item);
	m_depotFilesList.Update(item);
}

	
void CDepotDiffDlg::FixupMenu(CMenu* menu)
{
	UINT enableType;
    menu->EnableMenuItem(ID_LMP_VIEW, MF_BYCOMMAND | (MF_DISABLED | MF_GRAYED));

	enableType = MF_ENABLED;
	if (m_selectedCount > 1)
	{
		enableType = MF_DISABLED | MF_GRAYED;
	}
	else
	{
		// Pointless for loop, but at least it's consistent with the others.
		for (int i = 0; i < m_selectedCount; ++i)
		{
			const FileInfo* fileInfo = m_selectedFiles[i];
			FileInfo::FileOp fileOp = fileInfo->GetFileOp();
			if (fileOp != FileInfo::DIFF_REV  &&  fileOp != FileInfo::WRITABLE)
			{
				enableType = MF_DISABLED | MF_GRAYED;
				break;
			}
		}
	}
    menu->EnableMenuItem(ID_LMP_SHOWDIFFERENCES, MF_BYCOMMAND | enableType);

	// Enable/disable Add Files.
	enableType = MF_ENABLED;
	if (m_activeListType == CDiffListCtrl::DEPOT_FILES)
		enableType = MF_DISABLED | MF_GRAYED;
	else
	{
		for (int i = 0; i < m_selectedCount; ++i)
		{
			const FileInfo* fileInfo = m_selectedFiles[i];
			FileInfo::FileOp fileOp = fileInfo->GetFileOp();
			if (fileOp == FileInfo::DEPOT_ONLY  ||  fileOp == FileInfo::SAME  ||
				fileOp == FileInfo::DIFF_REV  ||  fileOp == FileInfo::WRITABLE)
			{
				enableType = MF_DISABLED | MF_GRAYED;
				break;
			}
		}
	}
	menu->EnableMenuItem(ID_LMP_ADDFILES, MF_BYCOMMAND | enableType);

	// Enable/disable get latest version.
	enableType = MF_ENABLED;
	for (int i = 0; i < m_selectedCount; ++i)
	{
		const FileInfo* fileInfo = m_selectedFiles[i];
		FileInfo::FileOp fileOp = fileInfo->GetFileOp();
		if (m_activeListType == CDiffListCtrl::DEPOT_FILES  &&  fileOp == FileInfo::DEPOT_ONLY)
			continue;
		if (fileOp != FileInfo::DIFF_REV  &&  fileOp != FileInfo::WRITABLE)
		{
			enableType = MF_DISABLED | MF_GRAYED;
			break;
		}
	}
	menu->EnableMenuItem(ID_LMP_GETLATESTVERSION, MF_BYCOMMAND | enableType);

	// Enable/disable check out.
	enableType = MF_ENABLED;
	for (i = 0; i < m_selectedCount; ++i)
	{
		const FileInfo* fileInfo = m_selectedFiles[i];
		FileInfo::FileOp fileOp = fileInfo->GetFileOp();
		if (fileOp != FileInfo::DIFF_REV  &&  fileOp != FileInfo::WRITABLE)
		{
			enableType = MF_DISABLED | MF_GRAYED;
			break;
		}
	}
	menu->EnableMenuItem(ID_LMP_CHECKOUT, MF_BYCOMMAND | enableType);

	menu->EnableMenuItem(ID_LMP_CHECKIN, MF_BYCOMMAND | (MF_DISABLED | MF_GRAYED));
	menu->EnableMenuItem(ID_LMP_UNDOCHECKOUT, MF_BYCOMMAND | (MF_DISABLED | MF_GRAYED));
	menu->EnableMenuItem(ID_LMP_PROPERTIES, MF_BYCOMMAND | (MF_DISABLED | MF_GRAYED));
}

	
void CDepotDiffDlg::GetSelectedFiles()
{
	// Set up the active list control.
	m_activeListCtrl = (m_activeListType == CDiffListCtrl::DEPOT_FILES) ? &m_depotFilesList : &m_localFilesList;

	// Erase previous stuff.
	m_selectedFiles.Empty();
	m_selectedItems.RemoveAll();

	// Drop all the selected files in a file list.
	int curSel = m_activeListCtrl->GetNextItem(-1, LVNI_ALL | LVNI_SELECTED);
	while (curSel != -1)
	{
		// Get the file info.
		const FileInfo* fileInfo = theApp.GetDiffFiles()[curSel];
		m_selectedFiles.Add(*fileInfo);

		m_selectedItems.Add(curSel);

		curSel = m_activeListCtrl->GetNextItem(curSel, LVNI_ALL | LVNI_SELECTED);
	}

	m_selectedCount = m_selectedFiles.GetCount();
}


void RemoveAllDirectories( CString dirName )
{
	WIN32_FIND_DATA fd;
	HANDLE handle = FindFirstFile( dirName + "*.*", &fd );
	
	while (handle != INVALID_HANDLE_VALUE)
	{
		if ( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY )
		{
			if ( strcmp( fd.cFileName, "." ) != 0  &&  strcmp( fd.cFileName, ".." ) != 0 )
			{
				// Directory.
				RemoveAllDirectories( dirName + fd.cFileName + "\\" );
			}
		}
		else
		{
			SetFileAttributes( dirName + fd.cFileName, FILE_ATTRIBUTE_ARCHIVE );
			DeleteFile( dirName + fd.cFileName );
		}

		if ( !FindNextFile( handle, &fd ) )
			break;
	}

	FindClose( handle );

	RemoveDirectory( dirName );
}


void CDepotDiffDlg::CommandDelete()
{
	bool asked = false;
	UINT response = IDNO;
	CString msg;

	for (int i = 0; i < m_selectedCount; ++i)
	{
		FileInfo* fileInfo = const_cast<FileInfo*>(m_selectedFiles[i]);
		if (m_activeListType == CDiffListCtrl::DEPOT_FILES)
		{
			if (fileInfo->IsDirectory())
			{
				if ( !asked )
				{
				msg.Format("Remove the directory [%s] from the depot?", fileInfo->GetFullPath());
					response = AfxMessageBox(msg, MB_YESNOCANCEL);
					asked = true;
				}

				if ( response == IDYES )
				{
					DepotDelete depotDelete;
					depotDelete.Run(theApp.GetClientApi(), fileInfo->GetFullPath() + "...");
				}
				else if ( response == IDCANCEL )
					break;
			}
			else
			{
				if ( !asked )
				{
				msg.Format("Remove the file [%s] from the depot?", fileInfo->GetFullPath());
					response = AfxMessageBox(msg, MB_YESNOCANCEL);
					asked = true;
				}

				if ( response == IDYES )
				{
					DepotDelete depotDelete;
					depotDelete.Run(theApp.GetClientApi(), fileInfo->GetFullPath());
				}
				else if ( response == IDCANCEL )
					break;
			}
		}
		else if (m_activeListType == CDiffListCtrl::LOCAL_FILES)
		{
			if (fileInfo->IsDirectory())
			{
				if ( !asked )
				{
				msg.Format("Remove the directory [%s] from the hard drive?  This process is irreversible!",
						fileInfo->GetFullPath());
					response = AfxMessageBox(msg, MB_YESNOCANCEL);
					asked = true;
				}

				if ( response == IDYES )
				{
					RemoveAllDirectories( fileInfo->GetFullPath() );
				}
				else if ( response == IDCANCEL )
					break;
			}
			else
			{
				if ( !asked )
				{
				msg.Format("Remove the file [%s] from the hard drive?  This process is irreversible!",
						fileInfo->GetFullPath());
					response = AfxMessageBox(msg, MB_YESNOCANCEL);
					asked = true;
				}

				if ( response == IDYES )
				{
					DeleteFile(fileInfo->GetFullPath());
				}
				else if ( response == IDCANCEL )
					break;
			}
		}

		RemoveDiffFile(i);
	}
}


void CDepotDiffDlg::PopupMenu(CPoint* inPoint)
{
	GetSelectedFiles();

	CPoint point;
	if (inPoint)
		point = *inPoint;
	else
		::GetCursorPos(&point);

	CMenu menu;
	menu.LoadMenu(IDR_FILESMENU);

	CMenu* popupMenu = (CMenu*)menu.GetSubMenu(0);

	// Fix up the menu.
	FixupMenu(popupMenu);

	BOOL ret = popupMenu->TrackPopupMenu(
		TPM_RETURNCMD | TPM_LEFTBUTTON | TPM_RIGHTBUTTON,
		point.x, point.y,
		this, NULL);
	if (ret == 0)
	{
		return;
	}
	
	switch (ret)
	{
		case ID_LMP_VIEW:
			break;
		case ID_LMP_SHOWDIFFERENCES:
		{
			// Pointless for loop, but at least it's consistent with the others.
			for (int i = 0; i < m_selectedCount; ++i)
			{
				const FileInfo* fileInfo = m_selectedFiles[i];
				DepotDiff depotDiff;
				depotDiff.Run(theApp.GetClientApi(), fileInfo->GetFullPath());
			}
			break;
		}

		case ID_LMP_ADDFILES:
		{
			for (int i = 0; i < m_selectedCount; ++i)
			{
				FileInfo* fileInfo = const_cast<FileInfo*>(m_selectedFiles[i]);
				if (fileInfo->IsDirectory())
				{
					DepotAddRecursive depotAdd;
					depotAdd.Run(theApp.GetClientApi(), fileInfo->GetFullPath());

					ChangeDiffFileOp(m_selectedItems[i], FileInfo::SAME);
				}
				else
				{
					DepotAdd depotAdd;
					depotAdd.Run(theApp.GetClientApi(), fileInfo->GetFullPath());

					RemoveDiffFile(i);
				}
			}

			break;
		}

		case ID_LMP_DELETE:
		{
			CommandDelete();
			break;
		}

		case ID_LMP_GETLATESTVERSION:
		{
			for (int i = 0; i < m_selectedCount; ++i)
			{
				FileInfo* fileInfo = const_cast<FileInfo*>(m_selectedFiles[i]);
				if (fileInfo->IsDirectory())
				{
					DepotSync depotSync;
					depotSync.Run(theApp.GetClientApi(), fileInfo->GetFullPath() + "...", true);

					ChangeDiffFileOp(m_selectedItems[i], FileInfo::SAME);
				}
				else
				{
					DepotSync depotSync;
					depotSync.Run(theApp.GetClientApi(), fileInfo->GetFullPath(), true);

					ChangeDiffFileOp(m_selectedItems[i], FileInfo::SAME);
					RemoveDiffFile(i);
				}
			}
			break;
		}

		case ID_LMP_CHECKOUT:
		{
			for (int i = 0; i < m_selectedCount; ++i)
			{
				FileInfo* fileInfo = const_cast<FileInfo*>(m_selectedFiles[i]);
				if (fileInfo->IsDirectory())
				{
					DepotEdit depotEdit;
					depotEdit.Run(theApp.GetClientApi(), fileInfo->GetFullPath() + "...");
				}
				else
				{
					DepotEdit depotEdit;
					depotEdit.Run(theApp.GetClientApi(), fileInfo->GetFullPath());
				}
			}
			break;
		}

		case ID_LMP_CHECKIN:
			break;
		case ID_LMP_UNDOCHECKOUT:
			break;
		case ID_LMP_PROPERTIES:
			break;
	}
}

void CDepotDiffDlg::OnNMRclickLocalFiles(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLISTVIEW* info = (NMLISTVIEW*)pNMHDR;

	m_activeListType = CDiffListCtrl::LOCAL_FILES;
	PopupMenu(NULL);

	*pResult = 0;
}

void CDepotDiffDlg::OnNMRclickDepotFiles(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLISTVIEW* info = (NMLISTVIEW*)pNMHDR;

	m_activeListType = CDiffListCtrl::DEPOT_FILES;
	PopupMenu(NULL);

	*pResult = 0;
}

void CDepotDiffDlg::OnBnClickedBrowse()
{
	CPickDirDlg dlg("Choose the directory to start the diff at", m_rootDirectory);
	CString dir = dlg.GetDirectory();
	if (!dir.IsEmpty())
	{
		m_rootDirectory = dir + "\\";

		m_diffPathEdit.SetWindowText(m_rootDirectory);
	}
}

void CDepotDiffDlg::OnOK()
{
	m_recursive = m_recursiveButton.GetCheck() != 0;
	m_diffPathEdit.GetWindowText(m_rootDirectory);
	m_rootDirectory.TrimRight("\\");
	m_rootDirectory.TrimLeft(" ");
	m_rootDirectory += "\\";
	m_diffPathEdit.SetWindowText(m_rootDirectory);

	Refresh(m_rootDirectory, m_recursive);
}


BOOL CDepotDiffDlg::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == WM_KEYUP)
	{
		if (pMsg->wParam == VK_F5)
		{
			Refresh(m_rootDirectory, m_recursive);

			return TRUE;
		}
	}

	return cdxCDynamicDialog::PreTranslateMessage(pMsg);
}

void CDepotDiffDlg::OnKeydownLocalFiles(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;

	if (pLVKeyDow->wVKey == VK_DELETE)
	{
		m_activeListType = CDiffListCtrl::LOCAL_FILES;

		GetSelectedFiles();
		CommandDelete();
	}
	
	*pResult = 0;
}

void CDepotDiffDlg::OnKeydownDepotFiles(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;

	if (pLVKeyDow->wVKey == VK_DELETE)
	{
		m_activeListType = CDiffListCtrl::DEPOT_FILES;

		GetSelectedFiles();
		CommandDelete();
	}
	
	
	*pResult = 0;
}
