// DepotDiffDlg.h : header file
//

#pragma once
#include "afxcmn.h"

#include "DiffListCtrl.h"
#include "DepotInfo.h"
#include "afxwin.h"

/////////////////////////////////////////////////////////////////////////////
// CDepotDiffDlg dialog

class CDepotDiffDlg : public cdxCDynamicDialog
{
// Construction
public:
	CDepotDiffDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CDepotDiffDlg)
	enum { IDD = IDD_DEPOTDIFF_DIALOG };
		// NOTE: the ClassWizard will add data members here
	CDiffListCtrl m_depotFilesList;
	CDiffListCtrl m_localFilesList;
	CEdit m_diffPathEdit;
	CButton m_recursiveButton;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDepotDiffDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

public:
	void SetRootDirectory(const CString& rootDir)
	{
		m_rootDirectory = rootDir;
		m_rootDirectory.TrimRight('\\');
		m_rootDirectory += "\\";
	}

	void SetRecursive(bool recursive)				{  m_recursive = recursive;  }

	void Refresh(CString dirName, bool recursive);

// Implementation
protected:
	void RefreshRecursive(FileList& toProcessFiles, CString dirName, bool recursive);
	void PopupMenu(CPoint* inPoint);
	void FixupMenu(CMenu* menu);
	void RemoveDiffFile(int index);
	void ChangeDiffFileOp(int item, FileInfo::FileOp newFileOp);
	void GetSelectedFiles();

	void CommandDelete();

	CString m_windowTitle;
	CString m_rootDirectory;
	bool m_recursive;

	FileList m_selectedFiles;
	CArray<int, int> m_selectedItems;
	int m_selectedCount;
	CDiffListCtrl::ListType m_activeListType;
	CDiffListCtrl* m_activeListCtrl;

	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CDepotDiffDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnNMRclickLocalFiles(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnNMRclickDepotFiles(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedBrowse();
	afx_msg void OnKeydownLocalFiles(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnKeydownDepotFiles(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
	DECLARE_DYNAMIC_MAP()

protected:
	virtual void OnOK();
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.


