// DiffListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "DepotDiff.h"
#include "DiffListCtrl.h"
#include "DepotInfo.h"

// CDiffListCtrl

IMPLEMENT_DYNAMIC(CDiffListCtrl, CListCtrl)
CDiffListCtrl::CDiffListCtrl() :
	m_nNextFree(0),
	m_listType(DEPOT_FILES)
{
}

CDiffListCtrl::~CDiffListCtrl()
{
}


BEGIN_MESSAGE_MAP(CDiffListCtrl, CListCtrl)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnNMCustomdraw)
	ON_NOTIFY_REFLECT(LVN_GETDISPINFO, OnLvnGetdispinfo)
	ON_WM_VSCROLL()
END_MESSAGE_MAP()



// CDiffListCtrl message handlers

LPTSTR CDiffListCtrl::AddPool(CString* pstr)
{
	LPTSTR pstrRetVal;
	int nOldest = m_nNextFree;

	m_strCPool[m_nNextFree] = *pstr;
	pstrRetVal = m_strCPool[m_nNextFree].LockBuffer();
	m_pstrPool[m_nNextFree++] = pstrRetVal;
	m_strCPool[nOldest].ReleaseBuffer();

	if (m_nNextFree == 3)
			m_nNextFree = 0;
	return pstrRetVal;
}

void CDiffListCtrl::OnNMCustomdraw(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMCUSTOMDRAW pNMCD = reinterpret_cast<LPNMCUSTOMDRAW>(pNMHDR);

	LPNMLVCUSTOMDRAW  lplvcd = (LPNMLVCUSTOMDRAW)pNMHDR;
	switch(lplvcd->nmcd.dwDrawStage)
	{
		case CDDS_PREPAINT:
			*pResult = CDRF_NOTIFYITEMDRAW;          // ask for item notifications.
			break;
		case CDDS_ITEMPREPAINT:
		{
			*pResult = CDRF_DODEFAULT;
			int iRow = (int)lplvcd->nmcd.dwItemSpec;
			CString text = GetItemText(iRow, 0);
			FileList& diffFiles = theApp.GetDiffFiles();
			if (iRow < diffFiles.GetCount())
			{
				const FileInfo* fileInfo = diffFiles[iRow];
				if (fileInfo)
				{
					switch (fileInfo->GetFileOp())
					{
						case FileInfo::LOCAL_ONLY:
							lplvcd->clrText = RGB(0, 128, 0);
							break;
						case FileInfo::DEPOT_ONLY:
							lplvcd->clrText = RGB(0, 0, 128);
							break;
						case FileInfo::DIFF_REV:
							lplvcd->clrText = RGB(255, 0, 0);
							break;
						case FileInfo::WRITABLE:
							lplvcd->clrText = RGB(128, 0, 128);
							break;
					}
					*pResult = CDRF_NEWFONT;
				}
			}
			break;
		}

		default:
			*pResult = CDRF_DODEFAULT;
	}
}


void CDiffListCtrl::OnLvnGetdispinfo(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	LVITEM* item = &pDispInfo->item;

	item->mask = LVIF_TEXT;

	FileList& diffFiles = theApp.GetDiffFiles();
	const FileInfo* fileInfo = diffFiles[item->iItem];

	CString strField;

	if (m_listType == DEPOT_FILES)
	{
		switch (fileInfo->GetFileOp())
		{
			case FileInfo::SAME:
			case FileInfo::DEPOT_ONLY:
			case FileInfo::DIFF_REV:
			case FileInfo::WRITABLE:
				strField = fileInfo->GetName();
				break;
		}
	}
	else if (m_listType == LOCAL_FILES)
	{
		switch (fileInfo->GetFileOp())
		{
			case FileInfo::SAME:
			case FileInfo::LOCAL_ONLY:
			case FileInfo::DIFF_REV:
			case FileInfo::WRITABLE:
				strField = fileInfo->GetName();
				break;
		}
	}

	LPTSTR pstrBuffer = AddPool(&strField);
	item->pszText = pstrBuffer;

	*pResult = 0;
}

void CDiffListCtrl::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	CListCtrl::OnVScroll(nSBCode, nPos, pScrollBar);

	int topIndex = GetTopIndex();
	int countPerPage = m_otherListCtrl->GetCountPerPage();
	m_otherListCtrl->EnsureVisible(topIndex + countPerPage - 1, TRUE);
	m_otherListCtrl->EnsureVisible(topIndex, FALSE);
}
