#pragma once

class FileInfo;

// CDiffListCtrl

class CDiffListCtrl : public CListCtrl
{
	DECLARE_DYNAMIC(CDiffListCtrl)

public:
	CDiffListCtrl();
	virtual ~CDiffListCtrl();

	enum ListType
	{
		DEPOT_FILES,
		LOCAL_FILES,
	};

	void SetListType(ListType listType)		{  m_listType = listType;  };
	void SetOtherListCtrl(CDiffListCtrl& otherListCtrl)	{  m_otherListCtrl = &otherListCtrl;  }

protected:
	LPTSTR AddPool(CString* pstr);

    CString m_strCPool[3];
    LPTSTR  m_pstrPool[3];
    int     m_nNextFree;

	ListType m_listType;

	CDiffListCtrl* m_otherListCtrl;

protected:
	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnNMCustomdraw(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnLvnGetdispinfo(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
};


