// AddIn.cpp : Implementation of DLL Exports.

#include "stdafx.h"
#include "resource.h"
#include "AddIn.h"

CAddInModule _AtlModule;


// DLL Entry Point
extern "C" BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	_AtlModule.SetResourceInstance(hInstance);
	return _AtlModule.DllMain(dwReason, lpReserved); 
}


// Used to determine whether the DLL can be unloaded by OLE
STDAPI DllCanUnloadNow(void)
{
	return _AtlModule.DllCanUnloadNow();
}


// Returns a class factory to create an object of the requested type
STDAPI DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
	return _AtlModule.DllGetClassObject(rclsid, riid, ppv);
}


static CString s_regBasePath70 = "Software\\Microsoft\\VisualStudio\\7.0";
static CString s_regBasePath71 = "Software\\Microsoft\\VisualStudio\\7.1";


// DllRegisterServer - Adds entries to the system registry
//
// The following code is derived from the Workspace Whiz for Visual Studio .NET source
// code.
STDAPI DllRegisterServer(void)
{
	// registers object, typelib and all interfaces in typelib
	HRESULT hr = _AtlModule.DllRegisterServer();

	// Get the module name.
	TCHAR moduleName[_MAX_PATH];
	moduleName[0] = 0;
	::GetModuleFileName(_AtlModule.GetResourceInstance(), (TCHAR*)&moduleName, _MAX_PATH);

	// Get the module path.
	TCHAR modulePath[_MAX_PATH];
	_tcscpy(modulePath, moduleName);
	TCHAR* ptr = _tcsrchr(modulePath, '\\');
	ptr++;
	*ptr++ = 0;

	// Get the short module name.
	TCHAR moduleShortName[_MAX_PATH];
	ptr = _tcsrchr(moduleName, '\\');
	_tcscpy(moduleShortName, ptr + 1);

	// Register the add-in's registry keys at:
	//   HKLM\Software\Microsoft\VisualStudio\7.0\AddIns\FastSolutionBuild.Connect
	// and
	//   HKLM\Software\Microsoft\VisualStudio\7.0\PreloadAddinState
	CRegKey devKey;
	if (devKey.Open(HKEY_LOCAL_MACHINE, s_regBasePath70) == ERROR_SUCCESS)
	{
		// Auto create the addins key if it isn't already there.
		if (devKey.Create(HKEY_LOCAL_MACHINE, s_regBasePath70 + "\\AddIns") == ERROR_SUCCESS)
		{
			// Create the FastSolutionBuild key.
			if (devKey.Create(HKEY_LOCAL_MACHINE, s_regBasePath70 + "\\AddIns\\FastSolutionBuild.Connect") == ERROR_SUCCESS)
			{
				// All of these entries are necessary for proper add-in creation.
				devKey.SetStringValue("SatelliteDLLPath", modulePath);
				devKey.SetStringValue("SatelliteDLLName", moduleShortName);
				devKey.SetDWORDValue("LoadBehavior", 3);
				devKey.SetStringValue("FriendlyName", "Fast Solution Build");
				devKey.SetStringValue("Description", "Dependency checking a la VC6 and multi project incremental linking.");
				devKey.SetDWORDValue("CommandPreload", 1);
			}
		}
	}

	if (devKey.Open(HKEY_CURRENT_USER, s_regBasePath70 + "\\PreloadAddinState") == ERROR_SUCCESS)
	{
		devKey.SetDWORDValue("FastSolutionBuild.Connect", 1);
	}

	// Auto create the addins key if it isn't already there.
	if (devKey.Open(HKEY_LOCAL_MACHINE, s_regBasePath71) == ERROR_SUCCESS)
	{
		if (devKey.Create(HKEY_LOCAL_MACHINE, s_regBasePath71 + "\\AddIns") == ERROR_SUCCESS)
		{
			// Create the FastSolutionBuild key.
			if (devKey.Create(HKEY_LOCAL_MACHINE, s_regBasePath71 + "\\AddIns\\FastSolutionBuild.Connect") == ERROR_SUCCESS)
			{
				// All of these entries are necessary for proper add-in creation.
				devKey.SetStringValue("SatelliteDLLPath", modulePath);
				devKey.SetStringValue("SatelliteDLLName", moduleShortName);
				devKey.SetDWORDValue("LoadBehavior", 3);
				devKey.SetStringValue("FriendlyName", "Fast Solution Build");
				devKey.SetStringValue("Description", "Dependency checking a la VC6 and multi project incremental linking.");
				devKey.SetDWORDValue("CommandPreload", 1);
			}
		}

		if (devKey.Open(HKEY_CURRENT_USER, s_regBasePath71 + "\\PreloadAddinState") == ERROR_SUCCESS)
		{
			devKey.SetDWORDValue("FastSolutionBuild.Connect", 1);
		}
	}

	if (SUCCEEDED(devKey.Create(HKEY_CURRENT_USER, "Software\\Fast Solution Build")))
	{
		devKey.SetDWORDValue("VSNET700FirstTime", 1);
		devKey.SetDWORDValue("VSNET710FirstTime", 1);

		// Ask the user if they want incremental linking on by default.
		if (::MessageBox(NULL, "Do you want multi-project incremental linking on by default?\n\n"
				"Choosing Yes allows multi-project incremental linking to happen in any case where "
				"the linker property pages specify Incremental Linking as on, without user intervention.  "
				"You can still control specific configurations for incremental linking through the "
				".vcprojFSB file.  Note that there are certain conditions for the multi-project incremental "
				"link facility to work, and those are described in the documentation.\n\n"
				"Choosing No will turn off multi-project linking unless a .vcprojFSB file exists.  For some "
				"users, this will be the safer option.\n",
				"Fast Solution Build Install", MB_YESNO) == IDYES)
		{
			devKey.SetDWORDValue("DefaultIncrementalLink70", 1);
			devKey.SetDWORDValue("DefaultIncrementalLink71", 1);
		}
		else
		{
			devKey.SetDWORDValue("DefaultIncrementalLink70", 0);
			devKey.SetDWORDValue("DefaultIncrementalLink71", 0);
		}
	}

	return hr;
}


// Unregister a single add-in command.
void UnregisterCommand(CComPtr<EnvDTE::Commands>& pCommands, LPCWSTR commandName)
{
	CComPtr<EnvDTE::Command> pCommand;
	HRESULT hr = pCommands->Item(CComVariant(L"FastSolutionBuild.Connect." + CStringW(commandName)), -1,
		&pCommand);

	if (SUCCEEDED(hr))
	{
		pCommand->Delete();
	}
}


void UnregisterAllCommands(CComPtr<EnvDTE::_DTE>& pDTE)
{
	CComPtr<EnvDTE::Commands> pCommands;
	pDTE->get_Commands(&pCommands);
	UnregisterCommand(pCommands, L"BuildActiveProject");
	UnregisterCommand(pCommands, L"DebugActiveProject");
	UnregisterCommand(pCommands, L"RunActiveProject");
}


// Connect through the DTE provider and unregister all the add-in commands.
void ConnectAndUnregisterAllCommands()
{
	CComPtr<EnvDTE::_DTE> pDTE;

	CLSID clsid;
	HRESULT hr = CLSIDFromProgID(L"VisualStudio.DTE.7", &clsid);
	if (SUCCEEDED(hr))
	{
		// Create the shell and get an interface to it.
		hr = CoCreateInstance(clsid, NULL, CLSCTX_LOCAL_SERVER,
			__uuidof(EnvDTE::_DTE), reinterpret_cast<void**>(&pDTE));
		if (pDTE)
		{
			UnregisterAllCommands(pDTE);
			pDTE = NULL;
		}
	}

	hr = CLSIDFromProgID(L"VisualStudio.DTE.7.1", &clsid);
	if (SUCCEEDED(hr))
	{
		hr = CoCreateInstance(clsid, NULL, CLSCTX_LOCAL_SERVER, __uuidof(EnvDTE::_DTE), reinterpret_cast<void**>(&pDTE));
		if (pDTE)
		{
			UnregisterAllCommands(pDTE);
			pDTE = NULL;
		}
	}
}


// DllUnregisterServer - Removes entries from the system registry
STDAPI DllUnregisterServer(void)
{
	HRESULT hr = _AtlModule.DllUnregisterServer();

	// Remove registry entries.
	CRegKey key;
	if (key.Open(HKEY_LOCAL_MACHINE, s_regBasePath70 + "\\AddIns") == ERROR_SUCCESS)
	{
		// Remove all old entries.
		key.RecurseDeleteKey("FastSolutionBuild.Connect");
	}

	if (key.Open(HKEY_LOCAL_MACHINE, s_regBasePath71 + "\\AddIns") == ERROR_SUCCESS)
	{
		// Remove all old entries.
		key.RecurseDeleteKey("FastSolutionBuild.Connect");
	}

	if (key.Open(HKEY_CURRENT_USER, "Software") == ERROR_SUCCESS)
	{
		key.RecurseDeleteKey("Fast Solution Build");
		key.RecurseDeleteKey("FastSolutionBuild");
	}

	ConnectAndUnregisterAllCommands();

	return hr;
}