// Connect.cpp : Implementation of CConnect
#include "stdafx.h"
#include "AddIn.h"
#include "Connect.h"

extern CAddInModule _AtlModule;

CConnect* s_connect;

// This is the GUID for .vcproj configurations.
CComBSTR cppKind = "{8BC9CEB8-8B4A-11D0-8D11-00A0C91BC942}";

class BuildEventsSink : public IDispEventImpl<1, BuildEventsSink, &__uuidof(EnvDTE::_dispBuildEvents), &EnvDTE::LIBID_EnvDTE, 7, 0>
{
public:
	BEGIN_SINK_MAP(BuildEventsSink)
		SINK_ENTRY_EX(1, __uuidof(EnvDTE::_dispBuildEvents), 4, OnBuildDone)
		SINK_ENTRY_EX(1, __uuidof(EnvDTE::_dispBuildEvents), 5, OnBuildProjConfigBegin)
		SINK_ENTRY_EX(1, __uuidof(EnvDTE::_dispBuildEvents), 6, OnBuildProjConfigDone)
	END_SINK_MAP()

    void __stdcall OnBuildDone(
					EnvDTE::vsBuildScope Scope,
                    EnvDTE::vsBuildAction Action)
	{
		// Route through to the CConnect class.
		s_connect->OnBuildDone();
	}

    HRESULT __stdcall OnBuildProjConfigBegin(
		BSTR Project, 
		BSTR ProjectConfig, 
		BSTR Platform, 
		BSTR SolutionConfig)
	{
		// Route through to the CConnect class.
		return s_connect->OnBuildProjConfigBegin(Project, ProjectConfig, Platform, SolutionConfig);
	}

	HRESULT __stdcall OnBuildProjConfigDone(
		BSTR Project,
		BSTR ProjectConfig,
		BSTR Platform,
		BSTR SolutionConfig,
		VARIANT_BOOL Success
	)
	{
		return s_connect->OnBuildProjConfigDone(Project, ProjectConfig, Platform, SolutionConfig, Success);
	}
};


BuildEventsSink m_BuildEventsSink;
CComPtr<EnvDTE::_BuildEvents> pBuildEvents;


void CConnect::SetKeyBinding(bool justText, const CStringW& command, const CStringW& binding)
{
	CComPtr<EnvDTE::Commands> pCommands;
	m_pDTE->get_Commands(&pCommands);

	CComPtr<EnvDTE::Command> pCommand;
	HRESULT hr = pCommands->Item(CComVariant(L"FastSolutionBuild.Connect." + command), -1,
		&pCommand);

	if (SUCCEEDED(hr))
	{
		CComVariant variant;
		pCommand->get_Bindings(&variant);

		CComSafeArray<VARIANT> sa;
		sa.Attach(variant.parray);
		LONG count = sa.GetCount();

		CStringW fullStr;
		if (!justText)
			fullStr = L"Global::" + binding;
		else
			fullStr = L"Text Editor::" + binding;

		CComVariant varFullStr = fullStr;
		sa.Add(varFullStr);

		pCommand->put_Bindings(variant);

		sa.Detach();
	}
}


// CConnect
STDMETHODIMP CConnect::OnConnection(IDispatch *pApplication, AddInDesignerObjects::ext_ConnectMode ConnectMode, IDispatch *pAddInInst, SAFEARRAY ** /*custom*/ )
{
	s_connect = this;

	m_pDTE = NULL;
	m_pAddInInstance = NULL;

	HRESULT hr = S_OK;
	pApplication->QueryInterface(__uuidof(EnvDTE::_DTE), (LPVOID*)&m_pDTE);
	pAddInInst->QueryInterface(__uuidof(EnvDTE::AddIn), (LPVOID*)&m_pAddInInstance);

	// Chances are, this won't work.
	if ( ConnectMode == AddInDesignerObjects::ext_cm_CommandLine )
		return S_OK;

	CComBSTR version;
	m_pDTE->get_Version(&version);
	
	CString keyName;
	m_vc70 =  (version == "7.00");

	CComPtr<EnvDTE::Commands> pCommands;
	CComPtr<Office::_CommandBars> pCommandBars;
	hr = m_pDTE->get_Commands(&pCommands);
	if ( FAILED( hr ) )
		return hr;
	if ( !pCommands )
		return E_FAIL;

	// Get the set of command bars for the application.
	try
	{
		hr = m_pDTE->get_CommandBars(&pCommandBars);
	}
	catch (...)
	{
		// This will exception in a command-line build.
	}

	// See if the toolbar has been created.
	bool forceRecreateOfToolbarAndCommands = true;

	if (pCommandBars)
	{
		CComPtr<Office::CommandBar> pCommandBar;
		hr = pCommandBars->get_Item(CComVariant(L"Tools"), &pCommandBar );
		if ( SUCCEEDED( hr ) )
		{
			CComPtr<Office::CommandBarControls> pCommandBarControls;
			pCommandBar->get_Controls( &pCommandBarControls );

			CComPtr<Office::CommandBarControl> pCommandBarControl;
			pCommandBarControls->get_Item(CComVariant("FSB-Build Active Project"), &pCommandBarControl);
			if (pCommandBarControl)
			{
				forceRecreateOfToolbarAndCommands = false;
			}
		}
	}

	if(ConnectMode == 5  ||  forceRecreateOfToolbarAndCommands)
	{
		CComPtr<Office::CommandBarControl> pCommandBarControl;
		CComPtr<EnvDTE::Command> pCreatedCommand;
		CComPtr<Office::CommandBar> pMenuBarCommandBar;

		if (pCommandBars)
		{
			pCommandBars->get_Item(CComVariant(L"Tools"), &pMenuBarCommandBar);
		}

		try
		{
			if(SUCCEEDED(pCommands->AddNamedCommand(m_pAddInInstance, CComBSTR("DebugActiveProject"), CComBSTR("FSB-Debug Active Project"), CComBSTR("Single project debug with dependency check a la VC6"), VARIANT_TRUE, 59, NULL, EnvDTE::vsCommandStatusSupported+EnvDTE::vsCommandStatusEnabled, &pCreatedCommand)) && (pCreatedCommand))
			{
				//Add a button to the tools menu bar.
				pCommandBarControl = NULL;
				if (pMenuBarCommandBar)
					pCreatedCommand->AddControl(pMenuBarCommandBar, 1, &pCommandBarControl);
			}

			pCreatedCommand = NULL;
			if(SUCCEEDED(pCommands->AddNamedCommand(m_pAddInInstance, CComBSTR("BuildActiveProject"), CComBSTR("FSB-Build Active Project"), CComBSTR("Dependency checking a la VC6"), VARIANT_TRUE, 59, NULL, EnvDTE::vsCommandStatusSupported+EnvDTE::vsCommandStatusEnabled, &pCreatedCommand)) && (pCreatedCommand))
			{
				//Add a button to the tools menu bar.
				pCommandBarControl = NULL;
				if (pMenuBarCommandBar)
					pCreatedCommand->AddControl(pMenuBarCommandBar, 1, &pCommandBarControl);
			}
		}
		catch (...)
		{
			// This can exception in a command-line build.
		}
	}

	CComPtr<EnvDTE::Events> pEvents;
	m_pDTE->get_Events(&pEvents);

	// If there are events registered and we got here, then VStudio is
	// really messing with us...
	if ( pBuildEvents )
	{
		m_BuildEventsSink.DispEventUnadvise((IUnknown*)pBuildEvents.p);
		pBuildEvents = NULL;
	}

	if(SUCCEEDED(pEvents->get_BuildEvents((EnvDTE::_BuildEvents**)&pBuildEvents)))
	{
		m_BuildEventsSink.DispEventAdvise((IUnknown*)pBuildEvents.p);
	}

	// Assign keys.
	if (pCommandBars)
	{
		CRegKey regKey;
		if (SUCCEEDED(regKey.Open(HKEY_CURRENT_USER, "Software\\Fast Solution Build")))
		{
			keyName = m_vc70 ? "VSNET700FirstTime" : "VSNET710FirstTime";

			DWORD firstTime;
			regKey.QueryDWORDValue(keyName, firstTime);

			if (firstTime != 0)
			{
				regKey.SetDWORDValue(keyName, 0);

				if (::MessageBox(NULL, "Assign Fast Solution Build's BuildActiveProject to function key F7 "
						"and DebugActiveProject to function key F5?", "Fast Solution Build", MB_YESNO) == IDYES)
				{
					SetKeyBinding(false, L"BuildActiveProject", L"F7");
					SetKeyBinding(false, L"DebugActiveProject", L"F5");
				}
			}
		}
	}

	return S_OK;
}

STDMETHODIMP CConnect::OnDisconnection(AddInDesignerObjects::ext_DisconnectMode /*RemoveMode*/, SAFEARRAY ** /*custom*/ )
{
	if ( pBuildEvents )
	{
		m_BuildEventsSink.DispEventUnadvise((IUnknown*)pBuildEvents.p);
		pBuildEvents = NULL;
	}

	m_pAddInInstance = NULL;	
	m_pDTE = NULL;
	return S_OK;
}

STDMETHODIMP CConnect::OnAddInsUpdate (SAFEARRAY ** /*custom*/ )
{
	return S_OK;
}

STDMETHODIMP CConnect::OnStartupComplete (SAFEARRAY ** /*custom*/ )
{
	return S_OK;
}

STDMETHODIMP CConnect::OnBeginShutdown (SAFEARRAY ** /*custom*/ )
{
	return S_OK;
}

STDMETHODIMP CConnect::QueryStatus(BSTR bstrCmdName, EnvDTE::vsCommandStatusTextWanted NeededText, EnvDTE::vsCommandStatus *pStatusOption, VARIANT *pvarCommandText)
{
	if(NeededText == EnvDTE::vsCommandStatusTextWantedNone)
	{
		// Look up the DTE.Solution object.
		CComPtr<EnvDTE::_Solution> pSolution;
		m_pDTE->get_Solution(&pSolution);
		if (!pSolution)
		{
			*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusInvisible);
			return S_OK;
		}

		// Look up the DTE.Solution.SolutionBuild object.
		CComPtr<EnvDTE::SolutionBuild> pSolutionBuild;
		pSolution->get_SolutionBuild(&pSolutionBuild);
		if (!pSolutionBuild)
		{
			*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusInvisible);
			return S_OK;
		}

		EnvDTE::vsBuildState buildState;
		pSolutionBuild->get_BuildState(&buildState);

		if(!_wcsicmp(bstrCmdName, L"FastSolutionBuild.Connect.BuildActiveProject"))
		{
			if (buildState == EnvDTE::vsBuildStateInProgress)
				*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusInvisible);
			else
				*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusEnabled+EnvDTE::vsCommandStatusSupported);
		}
		else if (!_wcsicmp(bstrCmdName, L"FastSolutionBuild.Connect.DebugActiveProject"))
		{
			if (buildState == EnvDTE::vsBuildStateInProgress)
				*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusInvisible);
			else
				*pStatusOption = (EnvDTE::vsCommandStatus)(EnvDTE::vsCommandStatusEnabled+EnvDTE::vsCommandStatusSupported);
		}
	}
	return S_OK;
}


CComPtr<EnvDTE::OutputWindowPane> CConnect::GetOutputWindowPane(const CString& name, bool show)
{
	CComPtr<EnvDTE::Windows> windows;
	m_pDTE->get_Windows(&windows);

	CComPtr<EnvDTE::Window> window;
	windows->Item(CComVariant(EnvDTE::vsWindowKindOutput), &window);

	if (show)
		window->put_Visible(VARIANT_TRUE);

	CComPtr<IDispatch> dispOw;
	window->get_Object(&dispOw);

	CComQIPtr<EnvDTE::OutputWindow> ow(dispOw);
	CComPtr<EnvDTE::OutputWindowPanes> outputWindowPanes;
	ow->get_OutputWindowPanes(&outputWindowPanes);

	CComPtr<EnvDTE::OutputWindowPane> owPane;

	HRESULT hr = outputWindowPanes->Item(CComVariant(name), &owPane);
	if (FAILED(hr))
		outputWindowPanes->Add(CComBSTR(name), &owPane);

	owPane->Activate();

	return owPane;
}


/**
**/
void CConnect::ParseVCProjFSBFile(const CString& fileName)
{
	FILE* file = fopen(fileName, "rt");
	if (!file)
		return;

	// If the file exists, turn on incremental linking.
	m_doIncrementalLink = true;

	int lineNumber = 0;

	enum State
	{
		READ_VERSION,
		READ_EVERYTHING_ELSE,
	};

	State state = READ_VERSION;

	while (!feof(file))
	{
		CString line;
		fgets(CStrBuf(line, 2048), 2048, file);
		lineNumber++;

		line.TrimRight('\n');
		line.Trim();
		if (line.IsEmpty())
			continue;

		int equalsPos = line.Find('=');
		if (equalsPos == -1)
		{
			fclose(file);
			CString err;
			err.Format("Line #%d of file [%s] is invalid.  key=value expected.", lineNumber, fileName);
			::MessageBox(NULL, err, "Error", MB_OK);
			throw -1;
		}

		CString key = line.Left(equalsPos);
		key.Trim();

		int colonPos = key.Find(':');
		if (colonPos != -1)
		{
			CString configName = key.Left(colonPos);
			if (configName != m_solutionConfigurationName)
				continue;
			key = key.Mid(colonPos + 1);
		}

		CString value = line.Mid(equalsPos + 1);
		value.Trim();

		if (state == READ_VERSION)
		{
			key.MakeLower();
			if (key != "version"  ||  value != "1")
			{
				fclose(file);
				CString err;
				err.Format("Line #%d of file [%s] is invalid.  VERSION=1 expected.", lineNumber, fileName);
				::MessageBox(NULL, err, "Error", MB_OK);
				throw -1;
			}

			state = READ_EVERYTHING_ELSE;
		}
		else if (state == READ_EVERYTHING_ELSE)
		{
			key.MakeLower();
			if (key == "incrementallink")
			{
				value.MakeLower();
				m_doIncrementalLink = (value == "true");
			}
		}
	}

	fclose(file);
}


/**
	\return Returns false if no projects were built.  True if one or more projects
		were batched up to be built.
**/
bool CConnect::BuildActiveProject()
{
	m_numProjectsChecked = 0;
	m_totalProjects = 0;
	m_doIncrementalLink = false;

	// If the debugger is active, then behave like VS .NET does and ask the user
	// if they want to stop debugging so they can build.
	EnvDTE::vsIDEMode ideMode;
	m_pDTE->get_Mode(&ideMode);

	if (ideMode != EnvDTE::vsIDEModeDesign)
	{
		if (::MessageBox(NULL, "Do you want to stop debugging?", "Fast Solution Build", MB_YESNO) == IDYES)
		{
			// Get the debugger and wait for it to shut down.
			CComPtr<EnvDTE::Debugger> debugger;
			m_pDTE->get_Debugger(&debugger);
			if (debugger)
				debugger->Stop(VARIANT_TRUE);
		}
		else
		{
			// No project was built, but if false is returned, then DebugActiveProject()
			// might kick in and try to start the debugger.
			return true;
		}
	}

    // As per a VC6 build, save all files first.
	m_pDTE->ExecuteCommand(CComBSTR("File.SaveAll"), CComBSTR(""));

	// Get the active window, since playing with the Output pane changes the focus.
	CComPtr<EnvDTE::Window> activeWindow;
	m_pDTE->get_ActiveWindow(&activeWindow);

	// If no projects were built, then clear the Output pane and log a message.
	m_owPane = GetOutputWindowPane("Build", true);
    m_owPane->Clear();
    m_owPane->OutputString(CComBSTR("Build started... checking dependencies"));

	// Look up the DTE.Solution object.
	CComPtr<EnvDTE::_Solution> pSolution;
	m_pDTE->get_Solution(&pSolution);
	if (!pSolution)
	{
		throw -1;
		return false;
	}

	// Look up the count.
	long count;
	pSolution->get_Count(&count);
	m_totalProjects = count;

	// Look up the DTE.Solution.SolutionBuild object.
	pSolution->get_SolutionBuild(&m_pSolutionBuild);
	if (!m_pSolutionBuild)
	{
		throw -1;
		return false;
	}

	// Look up the DTE.Solution.SolutionBuild.StartupProjects array.
	CComVariant pProjectVariant;
	if (FAILED(m_pSolutionBuild->get_StartupProjects(&pProjectVariant)))
	{
		throw -1;
		return false;
	}

	// If the array has nothing in it, then they don't have any startup projects.
	CComSafeArray<VARIANT> startupProjects;
	startupProjects.Attach(pProjectVariant.parray);
	if (startupProjects.GetCount() == 0)
	{
		throw -1;
		return false;
	}

	VARIANT& startupProjectPath = startupProjects.GetAt(0);
	startupProjects.Detach();

	// DTE.Solution.SolutionBuild.ActiveConfiguration
	m_pSolutionBuild->get_ActiveConfiguration(&m_pSolutionConfiguration);
	if (!m_pSolutionConfiguration)
	{
		throw -1;
		return false;
	}

	// Get the SolutionConfiguration name.
	CComBSTR bstrConfig;
	m_pSolutionConfiguration->get_Name(&bstrConfig);
	m_solutionConfigurationName = CString(bstrConfig);

	// DTE.Solution.SolutionBuild.ActiveConfiguration.SolutionContexts
	m_pSolutionConfiguration->get_SolutionContexts(&m_pSolutionContexts);
	if (!m_pSolutionContexts)
	{
		throw -1;
		return false;
	}

	// DTE.Solution.Projects
	CComPtr<EnvDTE::Projects> pProjects;
	pSolution->get_Projects(&pProjects);
	if (!pProjects)
	{
		throw -1;
		return false;
	}

	// Look up the project object for the startup project.
	CComPtr<EnvDTE::Project> pActiveProject;
	pProjects->Item(startupProjectPath, &pActiveProject);
	if (!pActiveProject)
	{
		throw -1;
		return false;
	}

	// DTE.Solution.SolutionBuild.BuildDependencies
	m_pSolutionBuild->get_BuildDependencies(&m_pBuildDependencies);

	// Assign the project name we'll later need.
	CComBSTR projectName;
	pActiveProject->get_Name(&projectName);
	m_projectName = projectName;

	// Grab the solution file name and pick off the title.
	CComBSTR bstrSolutionFileName;
	pSolution->get_FileName(&bstrSolutionFileName);
	m_solutionName = bstrSolutionFileName;
	int dotPos = m_solutionName.ReverseFind('.');
	if (dotPos != -1)
		m_solutionName = m_solutionName.Left(dotPos);

	int slashPos = m_solutionName.ReverseFind('\\');
	if (slashPos != -1)
		m_solutionName = m_solutionName.Mid(slashPos + 1);

	// Recurse all the dependencies.
	bool ret;
	if (!RecurseDependencies(pActiveProject))
	{
        m_owPane->OutputString(CComBSTR(" build finished.\n"));
		ret = false;
	}
	else
	{
		m_ourBuild = true;

		// Batch compile all the projects now, in the order they were found.
		if (m_vc70)
		{
			POSITION pos = m_projectCompileOrder70.GetHeadPosition();
			while (pos)
			{
				VCConfiguration70& config = m_projectCompileOrder70.GetNext(pos);
				config->Build();
			}
		}
		else
		{
			POSITION pos = m_projectCompileOrder71.GetHeadPosition();
			while (pos)
			{
				VCConfiguration71& config = m_projectCompileOrder71.GetNext(pos);
				config->Build();
			}
		}

		ret = true;
	}

	// Set the active window back.
	if (activeWindow)
	{
		activeWindow->Activate();
	}

	return ret;
}


wchar_t* __cdecl wcsistr(const wchar_t* str1, const wchar_t* str2)
{
	if ( !*str2 )
		return((wchar_t *)str1);

	wchar_t* cp = (wchar_t*) str1;
	while (*cp)
	{
		wchar_t* s1 = cp;
		wchar_t* s2 = (wchar_t *) str2;

		while ( *s1 && *s2 && !(tolower(*s1)-tolower(*s2)) )
			s1++, s2++;

		if (!*s2)
			return(cp);

		cp++;
	}

	return NULL;
}

int ReplaceNoCase(CStringW& str, CStringW::PCXSTR pszOld, CStringW::PCXSTR pszNew)
{
	typedef CStringW::PCXSTR PCXSTR;
	typedef CStringW::PXSTR PXSTR;
	typedef CStringW::XCHAR XCHAR;

	// can't have empty or NULL lpszOld

	// nSourceLen is in XCHARs
	int nSourceLen = CStringW::StrTraits::SafeStringLen( pszOld );
	if( nSourceLen == 0 )
		return( 0 );
	// nReplacementLen is in XCHARs
	int nReplacementLen = CStringW::StrTraits::SafeStringLen( pszNew );

	// loop once to figure out the size of the result string
	int nCount = 0;
	{
		PCXSTR pszStart = str.GetString();
		PCXSTR pszEnd = pszStart+str.GetLength();
		while( pszStart < pszEnd )
		{
			PCXSTR pszTarget;
			while( (pszTarget = wcsistr( pszStart, pszOld ) ) != NULL)
			{
				nCount++;
				pszStart = pszTarget+nSourceLen;
			}
			pszStart += CStringW::StrTraits::SafeStringLen( pszStart )+1;
		}
	}

	// if any changes were made, make them
	if( nCount > 0 )
	{
		// if the buffer is too small, just
		//   allocate a new buffer (slow but sure)
		int nOldLength = str.GetLength();
		int nNewLength = nOldLength+(nReplacementLen-nSourceLen)*nCount;

		PXSTR pszBuffer = str.GetBuffer( max( nNewLength, nOldLength ) );

		PXSTR pszStart = pszBuffer;
		PXSTR pszEnd = pszStart+nOldLength;

		// loop again to actually do the work
		while( pszStart < pszEnd )
		{
			PXSTR pszTarget;
			while( (pszTarget = wcsistr( pszStart, pszOld ) ) != NULL )
			{
				int nBalance = nOldLength-int(pszTarget-pszBuffer+nSourceLen);
				memmove( pszTarget+nReplacementLen, pszTarget+nSourceLen, nBalance*sizeof( XCHAR ) );

				memcpy( pszTarget, pszNew, nReplacementLen*sizeof( XCHAR ) );
				pszStart = pszTarget+nReplacementLen;
				pszTarget[nReplacementLen+nBalance] = 0;
				nOldLength += (nReplacementLen-nSourceLen);
			}
			pszStart += CStringW::StrTraits::SafeStringLen( pszStart )+1;
		}
//		assert( pszBuffer[nNewLength] == 0 );
		str.ReleaseBufferSetLength( nNewLength );
	}

	return( nCount );
}


static CStringW GetModulePath()
{
	// Get the module path.
	WCHAR modulePath[_MAX_PATH];
	modulePath[0] = 0;
	::GetModuleFileNameW(_AtlModule.GetResourceInstance(), (WCHAR*)&modulePath, _MAX_PATH);
	WCHAR* ptr = wcsrchr(modulePath, '\\');
	*++ptr = 0;
	return modulePath;
}


HRESULT CConnect::OnBuildProjConfigBegin(BSTR Project, BSTR ProjectConfig, BSTR Platform, BSTR SolutionConfig)
{
	if (!m_ourBuild)
		return S_OK;

	// Get the solution directory.
	CComPtr<EnvDTE::_Solution> pSolution;
	m_pDTE->get_Solution(&pSolution);
	if (!pSolution)
	{
		// Somehow, we couldn't look up the project.  Exit.  An incremental link
		// may not happen, but it's better than a crash.
		return S_OK;
	}

	// DTE.Solution.Projects
	CComPtr<EnvDTE::Projects> pProjects;
	pSolution->get_Projects(&pProjects);
	if (!pProjects)
	{
		// Somehow, we couldn't look up the project.  Exit.  An incremental link
		// may not happen, but it's better than a crash.
		return S_OK;
	}

	// Look up the project object.
	CComPtr<EnvDTE::Project> pProject;
	pProjects->Item(CComVariant(Project), &pProject);
	if (!pProject)
	{
		// Somehow, we couldn't look up the project.  Exit.  An incremental link
		// may not happen, but it's better than a crash.
		return S_OK;
	}

	// Test the GUID and make sure we're only looking at C/C++ projects.
	CComBSTR bstrKind;
	pProject->get_Kind(&bstrKind);
	if (bstrKind != cppKind)
	{
		// Just tell the project to build as normal.  There is nothing to
		// incrementally link for a C# or VB project.
		return S_OK;
	}

	// VCProject
	CComPtr<IDispatch> pDispatch;
	pProject->get_Object(&pDispatch);

	// ConfigurationName|PlatformName
	CString configurationCombinedName = CString(ProjectConfig) + "|" + CString(Platform);
	CComBSTR bstrConfigurationCombinedName = configurationCombinedName;

	// Get the project path.
	CComBSTR bstrProjectPath;
	pProject->get_FullName(&bstrProjectPath);

	CString vcprojFSB = CString(bstrProjectPath) + "FSB";

	// Get the module path.
	CStringW modulePath = GetModulePath();

	if (m_vc70)
	{
		using namespace VCProjectEngineLibrary70;
		CComQIPtr<VCProject> pVCProject(pDispatch);

		// VCProject.Configurations
		CComPtr<IDispatch> pDispConfigs;
		pVCProject->get_Configurations(&pDispConfigs);
		CComQIPtr<IVCCollection> pVCConfigurations(pDispConfigs);

		// VCProject.Configurations[ConfigurationName|PlatformName]
		CComPtr<IDispatch> pDispConfig;
		pVCConfigurations->Item(CComVariant(bstrConfigurationCombinedName), &pDispConfig);
		CComQIPtr<VCConfiguration> pVCConfiguration(pDispConfig);
		if (!pVCConfiguration)
		{
			// Again, exit instead of crashing.
			return S_OK;
		}

		// Get the linker tool.
		CComPtr<IDispatch> pDispTools; 
		pVCConfiguration->get_Tools(&pDispTools); 
		if (!pDispTools)
		{
			// Weird.  Exit.
			return S_OK;
		}

		CComQIPtr<IVCCollection> pToolCol = pDispTools; 
		if (!pToolCol)
		{
			// Exit.
			return S_OK;
		}

		// Enumerate the Tools collection by name to get the Linker tool 
		CComPtr<IDispatch> pDispTool; 
		pToolCol->Item(CComVariant(L"VCLinkerTool"), &pDispTool);
		if (pDispTool) 
		{
			// If we got in here, then this project is the one that does the link.

			// See if we're forcing incremental linking.
			CRegKey devKey;
			if (devKey.Open(HKEY_CURRENT_USER, "Software\\Fast Solution Build") == ERROR_SUCCESS)
			{
				DWORD value;
				if (devKey.QueryDWORDValue("DefaultIncrementalLink70", value) == ERROR_SUCCESS)
				{
					m_doIncrementalLink = value != 0;
				}
			}

			// Open the file and stream it in.
			ParseVCProjFSBFile(vcprojFSB);

			CComQIPtr<VCLinkerTool> pLinkerTool(pDispTool);
			if (pLinkerTool)
			{
				linkIncrementalType linkType;
				pLinkerTool->get_LinkIncremental(&linkType);
				if (linkType == linkIncrementalNo)
					m_doIncrementalLink = false;
			}

			if (m_doIncrementalLink)
			{
				// Build the linker response file.
				CString rspFileName = CString(bstrProjectPath) + ".rsp";
				::SetEnvironmentVariable("FSB_LINK", "@" + rspFileName);

				// Get the platform pointer...
				CComPtr<IDispatch> pDispPlatforms;
				pVCProject->get_Platforms(&pDispPlatforms);
				CComQIPtr<IVCCollection> pPlatforms(pDispPlatforms);
				CComPtr<IDispatch> pDispPlatform;
				pPlatforms->Item(CComVariant(Platform), &pDispPlatform);
				m_pPlatform70 = pDispPlatform;

				// ... so we can modify the executable directory to point at our
				// LINK.exe first.
				CComBSTR bstrExecutableDirectories;
				m_pPlatform70->get_ExecutableDirectories(&bstrExecutableDirectories);
				CStringW dirs(bstrExecutableDirectories);
				ReplaceNoCase(dirs, modulePath + ";", L"");
				ReplaceNoCase(dirs, modulePath, L"");
				dirs = modulePath + ";" + dirs;
				m_pPlatform70->put_ExecutableDirectories(CComBSTR(dirs));
			}
		}
	}
	else
	{
		using namespace VCProjectEngineLibrary71;
		CComQIPtr<VCProject> pVCProject(pDispatch);

		// VCProject.Configurations
		CComPtr<IDispatch> pDispConfigs;
		pVCProject->get_Configurations(&pDispConfigs);
		CComQIPtr<IVCCollection> pVCConfigurations(pDispConfigs);

		// VCProject.Configurations[ConfigurationName|PlatformName]
		CComPtr<IDispatch> pDispConfig;
		pVCConfigurations->Item(CComVariant(bstrConfigurationCombinedName), &pDispConfig);
		CComQIPtr<VCConfiguration> pVCConfiguration(pDispConfig);
		if (!pVCConfiguration)
		{
			// Again, exit instead of crashing.
			return S_OK;
		}

		// Get the linker tool.
		CComPtr<IDispatch> pDispTools; 
		pVCConfiguration->get_Tools(&pDispTools); 
		if (!pDispTools)
		{
			// Weird.  Exit.
			return S_OK;
		}

		CComQIPtr<IVCCollection> pToolCol = pDispTools; 
		if (!pToolCol)
		{
			// Exit.
			return S_OK;
		}

		// Enumerate the Tools collection by name to get the Linker tool 
		CComPtr<IDispatch> pDispTool; 
		pToolCol->Item(CComVariant(L"VCLinkerTool"), &pDispTool);
		if (pDispTool) 
		{
			// If we got in here, then this project is the one that does the link.

			// See if we're forcing incremental linking.
			CRegKey devKey;
			if (devKey.Open(HKEY_CURRENT_USER, "Software\\Fast Solution Build") == ERROR_SUCCESS)
			{
				DWORD value;
				if (devKey.QueryDWORDValue("DefaultIncrementalLink71", value) == ERROR_SUCCESS)
				{
					m_doIncrementalLink = value != 0;
				}
			}

			// Open the file and stream it in.
			ParseVCProjFSBFile(vcprojFSB);

			CComQIPtr<VCLinkerTool> pLinkerTool(pDispTool);
			if (pLinkerTool)
			{
				linkIncrementalType linkType;
				pLinkerTool->get_LinkIncremental(&linkType);
				if (linkType == linkIncrementalNo)
					m_doIncrementalLink = false;
			}

			if (m_doIncrementalLink)
			{
				// Build the linker response file.
				CString rspFileName = CString(bstrProjectPath) + ".rsp";
				::SetEnvironmentVariable("FSB_LINK", "@" + rspFileName);

				// Get the platform pointer...
				CComPtr<IDispatch> pDispPlatforms;
				pVCProject->get_Platforms(&pDispPlatforms);
				CComQIPtr<IVCCollection> pPlatforms(pDispPlatforms);
				CComPtr<IDispatch> pDispPlatform;
				pPlatforms->Item(CComVariant(Platform), &pDispPlatform);
				m_pPlatform71 = pDispPlatform;

				// ... so we can modify the executable directory to point at our
				// LINK.exe first.
				CComBSTR bstrExecutableDirectories;
				m_pPlatform71->get_ExecutableDirectories(&bstrExecutableDirectories);
				CStringW dirs(bstrExecutableDirectories);
				ReplaceNoCase(dirs, modulePath + ";", L"");
				ReplaceNoCase(dirs, modulePath, L"");
				dirs = modulePath + ";" + dirs;
				m_pPlatform71->put_ExecutableDirectories(CComBSTR(dirs));
			}
		}
	}

	return S_OK;
}


HRESULT CConnect::OnBuildProjConfigDone(BSTR Project, BSTR ProjectConfig, BSTR Platform, BSTR SolutionConfig, VARIANT_BOOL Success)
{
	if (!m_ourBuild)
		return S_OK;

	// Remove the FSB_LINK environment variable.
	::SetEnvironmentVariable("FSB_LINK", NULL);

	// Get the module path.
	CStringW modulePath = GetModulePath();

	// If we played with the executable path to launch our LINK.exe, put it back the
	// way it was.
	if (m_vc70)
	{
		if (m_pPlatform70)
		{
			CComBSTR bstrDirs;
			m_pPlatform70->get_ExecutableDirectories(&bstrDirs);
			CStringW dirs(bstrDirs);
			ReplaceNoCase(dirs, modulePath, L"");
			ReplaceNoCase(dirs, modulePath + ";", L"");

			m_pPlatform70->put_ExecutableDirectories(CComBSTR(dirs));
			m_pPlatform70.Release();
		}
	}
	else
	{
		if (m_pPlatform71)
		{
			CComBSTR bstrDirs;
			m_pPlatform71->get_ExecutableDirectories(&bstrDirs);
			CStringW dirs(bstrDirs);
			ReplaceNoCase(dirs, modulePath, L"");
			ReplaceNoCase(dirs, modulePath + ";", L"");

			m_pPlatform71->put_ExecutableDirectories(CComBSTR(dirs));
			m_pPlatform71.Release();
		}
	}

	// Only cancel the build on failure if Fast Solution Build initiated it.
	if (Success == VARIANT_FALSE)
	{
		m_pDTE->ExecuteCommand(CComBSTR("Build.Cancel"), CComBSTR(""));
		m_ourBuild = false;
		return S_OK;
	}

	return S_OK;
}

	
/**
	In order for DebugActiveProject to work, the build has to be completed first.
	Since the build is multithreaded, we have to wait for the OnBuildDone event.
**/
void CConnect::OnBuildDone()
{
	// m_pSolutionBuild is not NULL only when a project was built and
	// DebugActiveProject() was called.
	if (m_ourBuild  &&  m_pSolutionBuild)
	{
		m_ourBuild = false;

		// To prevent any weird exception mechanisms from leaving behind bad
		// data, immediately assign the global to NULL.
		CComPtr<EnvDTE::SolutionBuild> pSolutionBuild = m_pSolutionBuild;
		m_pSolutionBuild = NULL;

		// Were there any build errors?
		long lastBuildInfo;
		pSolutionBuild->get_LastBuildInfo(&lastBuildInfo);
		if (lastBuildInfo == 0)
		{
			// Nope.  Start the debugger.
//			m_pDTE->ExecuteCommand(CComBSTR("Debug.Start"), CComBSTR(""));

			DebugActiveProject();
		}
	}
}

	
bool CConnect::RecurseDependencies(CComPtr<EnvDTE::Project>& pProject)
{
	// Grab the project name.
	CComBSTR projectName;
	pProject->get_Name(&projectName);

	// Pull out the build dependency for the project.
	CComPtr<EnvDTE::BuildDependency> pBuildDependency;
	m_pBuildDependencies->Item(CComVariant(pProject), &pBuildDependency);
	if (!pBuildDependency)
		return false;

	// Get the project's unique name to look up its solution context.
	CComBSTR projectUniqueName;
	pProject->get_UniqueName(&projectUniqueName);

	// Look up the solution context.
	CComPtr<EnvDTE::SolutionContext> pSolutionContext;
	m_pSolutionContexts->Item(CComVariant(projectUniqueName), &pSolutionContext);

	// If they've turned off the building of this project in the current solution
	// configuration, then ignore the rest.
	VARIANT_BOOL shouldBuild;
	pSolutionContext->get_ShouldBuild(&shouldBuild);
	if (shouldBuild == VARIANT_FALSE)
		return false;

	// The ConfigurationName|PlatformName is how VC .NET stores the actual config
	// name.
	CComBSTR bstrConfigurationName;
	pSolutionContext->get_ConfigurationName(&bstrConfigurationName);

	CComBSTR bstrPlatformName;
	pSolutionContext->get_PlatformName(&bstrPlatformName);

	CString configurationCombinedName = CString(bstrConfigurationName) + "|" + CString(bstrPlatformName);
	CComBSTR bstrConfigurationCombinedName = configurationCombinedName;

	// Get the project path.
	CComBSTR bstrProjectPath;
	pProject->get_FullName(&bstrProjectPath);
	CString projectPath(bstrProjectPath);
	int slashPos = projectPath.ReverseFind('\\');
	projectPath = projectPath.Left(slashPos + 1);

	// Grab the BuildDependency.RequiredProjects array.
	CComSafeArray<VARIANT> requiredProjects;
	CComVariant requiredProjectsVariant;
	pBuildDependency->get_RequiredProjects(&requiredProjectsVariant);
	requiredProjects.Attach(requiredProjectsVariant.parray);

	bool mustBuild = false;

	// Wander all the required projects.
	long requiredProjectsCount = requiredProjects.GetCount();
	for (long i = 0; i < requiredProjectsCount; ++i)
	{
		// Grab the current required project.
		VARIANT& projectVariant = requiredProjects.GetAt(i);
		CComQIPtr<EnvDTE::Project> pProjectDependency(projectVariant.pdispVal);

		// Get its unique name, since the map we use to determine if the project
		// has already been built uses the unique name as the key.
		CComBSTR projectDependencyUniqueName;
		pProjectDependency->get_UniqueName(&projectDependencyUniqueName);

		// Has the project already been built?  If not, recurse the dependencies
		// for it.
		ProjectsMap::CPair* it = m_projectsProcessed.Lookup(projectDependencyUniqueName);
		if (!it  &&  RecurseDependencies(pProjectDependency))
		{
			// The dependency built, so we must build this project.
			mustBuild = true;
		}
	}

	requiredProjects.Detach();

	// Tell the map we've built this project (or rather, we're going to build it
	// shortly).
	m_projectsProcessed[projectUniqueName] = true;

	// Show it in the output pane.
	m_owPane->OutputString(CComBSTR("."));

	// Test the GUID and make sure we're only looking at C/C++ projects.
	CComBSTR bstrKind;
	pProject->get_Kind(&bstrKind);
	if (bstrKind != cppKind)
	{
		// Just tell the project to build as normal.
		m_pSolutionBuild->BuildProject(bstrConfigurationName, projectUniqueName, FALSE);
		return true;
	}

	// VCProject
	CComPtr<IDispatch> pDispatch;
	pProject->get_Object(&pDispatch);

	// Get the solution directory.
	CComPtr<EnvDTE::_Solution> pSolution;
	m_pDTE->get_Solution(&pSolution);

	CComBSTR bstrFullPath;
	pSolution->get_FullName(&bstrFullPath);

	// Strip the solutionName.sln, leaving only the path.
	CString solutionPath(bstrFullPath);
	slashPos = solutionPath.ReverseFind('\\');
	solutionPath = solutionPath.Left(slashPos + 1);

	if (m_vc70)
	{
		using namespace VCProjectEngineLibrary70;
		CComQIPtr<VCProject> pVCProject(pDispatch);

		// VCProject.Configurations
		CComPtr<IDispatch> pDispConfigs;
		pVCProject->get_Configurations(&pDispConfigs);
		CComQIPtr<IVCCollection> pVCConfigurations(pDispConfigs);

		// VCProject.Configurations[ConfigurationName|PlatformName]
		CComPtr<IDispatch> pDispConfig;
		pVCConfigurations->Item(CComVariant(bstrConfigurationCombinedName), &pDispConfig);
		CComQIPtr<VCConfiguration> pVCConfiguration(pDispConfig);
		if (!pVCConfiguration)
		{
			CStringW err;
			err.Format(L"The Fast Solution Build add-in discovered an incorrect portion of your solution configuration.\n\n"
					L"The project [%s] is assigned the configuration [%s], but that configuration doesn't exist in the "
					L"project.\n", projectName, CStringW(configurationCombinedName));
			::MessageBoxW(NULL, err, L"Error", MB_OK);
			return false;
		}
		m_numProjectsChecked++;

		// Get the linker tool.
		bool didLinkThisProject = false;

		CComPtr<IDispatch> pDispTools; 
		pVCConfiguration->get_Tools(&pDispTools); 
		if (pDispTools) 
		{ 
			CComQIPtr<IVCCollection> pToolCol = pDispTools; 

			// Enumerate the Tools collection by name to get the Linker tool 
			CComPtr<IDispatch> pDispTool; 
			pToolCol->Item(CComVariant(L"VCLinkerTool"), &pDispTool);
			if (pDispTool) 
			{
				// If we got in here, then this project is the one that does the link.

				// See if we're forcing incremental linking.
				CRegKey devKey;
				if (devKey.Open(HKEY_CURRENT_USER, "Software\\Fast Solution Build") == ERROR_SUCCESS)
				{
					DWORD value;
					if (devKey.QueryDWORDValue("DefaultIncrementalLink70", value) == ERROR_SUCCESS)
					{
						m_doIncrementalLink = value != 0;
					}
				}

				// Open the file and stream it in.
				CString vcprojFSB = CString(bstrProjectPath) + "FSB";
				ParseVCProjFSBFile(vcprojFSB);

				CComQIPtr<VCLinkerTool> pLinkerTool(pDispTool);
				if (pLinkerTool)
				{
					linkIncrementalType linkType;
					pLinkerTool->get_LinkIncremental(&linkType);
					if (linkType == linkIncrementalNo)
						m_doIncrementalLink = false;
				}

				if (m_doIncrementalLink)
				{
					// Build the linker response file.
					CString rspFileName = CString(bstrProjectPath) + ".rsp";
					FILE* file = fopen(rspFileName, "wt");
					fputs(m_objFiles + " ", file);
					fclose(file);

					didLinkThisProject = true;
				}
			}
		}

		// Get the Intermediate directory.
		CComBSTR bstrIntermediateDirectory;
		pVCConfiguration->get_IntermediateDirectory(&bstrIntermediateDirectory);
		pVCConfiguration->Evaluate(bstrIntermediateDirectory, &bstrIntermediateDirectory);

		// Make sure the intermediate directory has a closing backslash.
		CString tempIntermediateDirectory(bstrIntermediateDirectory);
		tempIntermediateDirectory.TrimRight('\\').Append("\\");

		// Make the intermediate directory an absolute path.
		char currentDirectory[_MAX_PATH];
		GetCurrentDirectory(_MAX_PATH, currentDirectory);
		SetCurrentDirectory(projectPath);

		CString intermediateDirectory;
		_fullpath(CStrBuf(intermediateDirectory, _MAX_PATH), tempIntermediateDirectory, _MAX_PATH);

		SetCurrentDirectory(currentDirectory);

		// Get the file list in the project.
		CComPtr<IDispatch> pDispFiles;
		pVCProject->get_files(&pDispFiles);

		CComQIPtr<IVCCollection> pFiles(pDispFiles);

		// Make the intermediate directory an absolute path.
		GetCurrentDirectory(_MAX_PATH, currentDirectory);
		SetCurrentDirectory(projectPath);

		long count;
		pFiles->get_Count(&count);
		for (int index = 1; index <= count; ++index)
		{
			CComPtr<IDispatch> pDispFile;
			pFiles->Item(CComVariant(index), &pDispFile);
			CComQIPtr<VCFile> pFile(pDispFile);

			CComPtr<IDispatch> pDispFileConfigurations;
			pFile->get_FileConfigurations(&pDispFileConfigurations);
			CComQIPtr<IVCCollection> pVCCollection(pDispFileConfigurations);

			CComPtr<IDispatch> pDispFileConfiguration;
			pVCCollection->Item(CComVariant(bstrConfigurationCombinedName), &pDispFileConfiguration);
			CComQIPtr<VCFileConfiguration> pVCFileConfiguration(pDispFileConfiguration);
			
			VARIANT_BOOL excludedFromBuild;
			pVCFileConfiguration->get_ExcludedFromBuild(&excludedFromBuild);

			if (excludedFromBuild == VARIANT_FALSE)
			{
				CComBSTR fileName;
				pFile->get_Name(&fileName);

				// Rip the extension off.
				CString name(fileName);
				int dotPos = name.ReverseFind('.');
				if (dotPos != -1)
				{
					CString ext = name.Mid(dotPos + 1).MakeLower();
					name = name.Left(dotPos);

					// Enumerate the Tools collection by name to get the Linker tool 
					CComPtr<IDispatch> pDispTool; 
					pVCFileConfiguration->get_Tool(&pDispTool);
					if (pDispTool)
					{
						CComQIPtr<VCCLCompilerTool> pTool(pDispTool);
						if (pTool)
						{
							CComBSTR bstrObjFileName;
							pTool->get_ObjectFile(&bstrObjFileName);
							if (bstrObjFileName == L"")
								bstrObjFileName = intermediateDirectory + name + ".obj";
							pVCFileConfiguration->Evaluate(bstrObjFileName, &bstrObjFileName);

							CString objFileName(bstrObjFileName);
							objFileName.Replace('/', '\\');

							if (objFileName[objFileName.GetLength() - 1] == '\\')
								objFileName = objFileName + name + ".obj";

							CString finalObjDirectory;
							_fullpath(CStrBuf(finalObjDirectory, _MAX_PATH), objFileName, _MAX_PATH);

							m_objFiles += "\"" + finalObjDirectory + "\"\n";
						}
					}
				}
			}
		}

		SetCurrentDirectory(currentDirectory);

		if (didLinkThisProject)
		{
			// There might be more links after this.
			m_objFiles.Empty();
		}

		// If we have to build the project anyway, due to a dependency being built,
		// then abort the up to date check, since it won't matter anyway.
		if (mustBuild)
		{
			m_projectCompileOrder70.AddTail(pVCConfiguration);
			return true;
		}

		// See if it is up to date.
		VARIANT_BOOL upToDate;
		pVCConfiguration->get_UpToDate(&upToDate);

		// If it isn't up to date, then build it.
		if (upToDate == VARIANT_FALSE)
		{
			m_projectCompileOrder70.AddTail(pVCConfiguration);
			return true;
		}

		return false;
	}
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	else
	{
		using namespace VCProjectEngineLibrary71;
		CComQIPtr<VCProject> pVCProject(pDispatch);

		// VCProject.Configurations
		CComPtr<IDispatch> pDispConfigs;
		pVCProject->get_Configurations(&pDispConfigs);
		CComQIPtr<IVCCollection> pVCConfigurations(pDispConfigs);

		// VCProject.Configurations[ConfigurationName|PlatformName]
		CComPtr<IDispatch> pDispConfig;
		pVCConfigurations->Item(CComVariant(bstrConfigurationCombinedName), &pDispConfig);
		CComQIPtr<VCConfiguration> pVCConfiguration(pDispConfig);
		if (!pVCConfiguration)
		{
			CStringW err;
			err.Format(L"The Fast Solution Build add-in discovered an incorrect portion of your solution configuration.\n\n"
					L"The project [%s] is assigned the configuration [%s], but that configuration doesn't exist in the "
					L"project.\n", projectName, CStringW(configurationCombinedName));
			::MessageBoxW(NULL, err, L"Error", MB_OK);
			return false;
		}

		m_numProjectsChecked++;

		// Get the linker tool.
		bool didLinkThisProject = false;

		CComPtr<IDispatch> pDispTools; 
		pVCConfiguration->get_Tools(&pDispTools); 
		if (pDispTools) 
		{ 
			CComQIPtr<IVCCollection> pToolCol = pDispTools; 

			// Enumerate the Tools collection by name to get the Linker tool 
			CComPtr<IDispatch> pDispTool; 
			pToolCol->Item(CComVariant(L"VCLinkerTool"), &pDispTool);
			if (pDispTool) 
			{
				// If we got in here, then this project is the one that does the link.

				// See if we're forcing incremental linking.
				CRegKey devKey;
				if (devKey.Open(HKEY_CURRENT_USER, "Software\\Fast Solution Build") == ERROR_SUCCESS)
				{
					DWORD value;
					if (devKey.QueryDWORDValue("DefaultIncrementalLink71", value) == ERROR_SUCCESS)
					{
						m_doIncrementalLink = value != 0;
					}
				}

				// Open the file and stream it in.
				CString vcprojFSB = CString(bstrProjectPath) + "FSB";
				ParseVCProjFSBFile(vcprojFSB);

				CComQIPtr<VCLinkerTool> pLinkerTool(pDispTool);
				if (pLinkerTool)
				{
					linkIncrementalType linkType;
					pLinkerTool->get_LinkIncremental(&linkType);
					if (linkType == linkIncrementalNo)
						m_doIncrementalLink = false;
				}

				if (m_doIncrementalLink)
				{
					// Build the linker response file.
					CString rspFileName = CString(bstrProjectPath) + ".rsp";
					FILE* file = fopen(rspFileName, "wt");
					fputs(m_objFiles + " ", file);
					fclose(file);

					didLinkThisProject = true;
				}
			}
		}

		// Get the Intermediate directory.
		CComBSTR bstrIntermediateDirectory;
		pVCConfiguration->get_IntermediateDirectory(&bstrIntermediateDirectory);
		pVCConfiguration->Evaluate(bstrIntermediateDirectory, &bstrIntermediateDirectory);

		// Make sure the intermediate directory has a closing backslash.
		CString tempIntermediateDirectory(bstrIntermediateDirectory);
		tempIntermediateDirectory.TrimRight('\\').Append("\\");

		// Make the intermediate directory an absolute path.
		char currentDirectory[_MAX_PATH];
		GetCurrentDirectory(_MAX_PATH, currentDirectory);
		SetCurrentDirectory(projectPath);

		CString intermediateDirectory;
		_fullpath(CStrBuf(intermediateDirectory, _MAX_PATH), tempIntermediateDirectory, _MAX_PATH);

		SetCurrentDirectory(currentDirectory);

		// Get the file list in the project.
		CComPtr<IDispatch> pDispFiles;
		pVCProject->get_Files(&pDispFiles);

		CComQIPtr<IVCCollection> pFiles(pDispFiles);

		// Make the intermediate directory an absolute path.
		GetCurrentDirectory(_MAX_PATH, currentDirectory);
		SetCurrentDirectory(projectPath);

		long count;
		pFiles->get_Count(&count);
		for (int index = 1; index <= count; ++index)
		{
			CComPtr<IDispatch> pDispFile;
			pFiles->Item(CComVariant(index), &pDispFile);
			CComQIPtr<VCFile> pFile(pDispFile);

			CComPtr<IDispatch> pDispFileConfigurations;
			pFile->get_FileConfigurations(&pDispFileConfigurations);
			CComQIPtr<IVCCollection> pVCCollection(pDispFileConfigurations);

			CComPtr<IDispatch> pDispFileConfiguration;
			pVCCollection->Item(CComVariant(bstrConfigurationCombinedName), &pDispFileConfiguration);
			CComQIPtr<VCFileConfiguration> pVCFileConfiguration(pDispFileConfiguration);
			
			VARIANT_BOOL excludedFromBuild;
			pVCFileConfiguration->get_ExcludedFromBuild(&excludedFromBuild);

			if (excludedFromBuild == VARIANT_FALSE)
			{
				CComBSTR fileName;
				pFile->get_Name(&fileName);

				// Rip the extension off.
				CString name(fileName);
				int dotPos = name.ReverseFind('.');
				if (dotPos != -1)
				{
					CString ext = name.Mid(dotPos + 1).MakeLower();
					name = name.Left(dotPos);

					// Enumerate the Tools collection by name to get the Linker tool 
					CComPtr<IDispatch> pDispTool; 
					pVCFileConfiguration->get_Tool(&pDispTool);
					if (pDispTool)
					{
						CComQIPtr<VCCLCompilerTool> pTool(pDispTool);
						if (pTool)
						{
							CComBSTR bstrObjFileName;
							pTool->get_ObjectFile(&bstrObjFileName);
							if (bstrObjFileName == L"")
								bstrObjFileName = intermediateDirectory + name + ".obj";
							pVCFileConfiguration->Evaluate(bstrObjFileName, &bstrObjFileName);

							CString objFileName(bstrObjFileName);
							objFileName.Replace('/', '\\');

							if (objFileName[objFileName.GetLength() - 1] == '\\')
								objFileName = objFileName + name + ".obj";

							CString finalObjDirectory;
							_fullpath(CStrBuf(finalObjDirectory, _MAX_PATH), objFileName, _MAX_PATH);

							m_objFiles += "\"" + finalObjDirectory + "\"\n";
						}
					}
				}
			}
		}

		SetCurrentDirectory(currentDirectory);

		if (didLinkThisProject)
		{
			// There might be more links after this.
			m_objFiles.Empty();
		}

		// If we have to build the project anyway, due to a dependency being built,
		// then abort the up to date check, since it won't matter anyway.
		if (mustBuild)
		{
			m_projectCompileOrder71.AddTail(pVCConfiguration);
			return true;
		}

		// See if it is up to date.
		VARIANT_BOOL upToDate;
		pVCConfiguration->get_UpToDate(&upToDate);

		// If it isn't up to date, then build it.
		if (upToDate == VARIANT_FALSE)
		{
			m_projectCompileOrder71.AddTail(pVCConfiguration);
			return true;
		}

		return false;
	}
}


void CConnect::DebugActiveProject()
{
	// Look up the Solution Explorer window.
	CComPtr<EnvDTE::Windows> windows;
	m_pDTE->get_Windows(&windows);

	CComPtr<EnvDTE::Window> window;
	windows->Item(CComVariant(EnvDTE::vsWindowKindSolutionExplorer), &window);
	
	// We have to activate it or the current selection can't be set.
	window->Activate();

	// Get the UIHierarchy object.
	CComPtr<IDispatch> pToolObject;
	window->get_Object(&pToolObject);

	CComQIPtr<EnvDTE::UIHierarchy> pUIHierarchy(pToolObject);
	
	// Get the tree item for the current solution and project.
	CComPtr<EnvDTE::UIHierarchyItem> pItem;
	pUIHierarchy->GetItem(CComBSTR(m_solutionName + "\\" + m_projectName), &pItem);

	// Select it.
	pItem->Select(EnvDTE::vsUISelectionTypeSelect);

	// The GUID below is the command sent when you right-click on a project and tell
	// it to start debugging.
	CComPtr<EnvDTE::Commands> pCommands;
	m_pDTE->get_Commands(&pCommands);

	CComVariant customIn, customOut;
	pCommands->Raise(CComBSTR("{1496A755-94DE-11D0-8C3F-00C04FC2AAE2}"), 356, &customIn, &customOut);
}


STDMETHODIMP CConnect::Exec(BSTR bstrCmdName, EnvDTE::vsCommandExecOption ExecuteOption, VARIANT * /*pvarVariantIn*/, VARIANT * /*pvarVariantOut*/, VARIANT_BOOL *pvbHandled)
{
	*pvbHandled = VARIANT_FALSE;
	
	m_objFiles.Empty();

	if(ExecuteOption == EnvDTE::vsCommandExecOptionDoDefault)
	{
		m_pSolutionBuild = NULL;

		// Look up the DTE.Solution object.
		CComPtr<EnvDTE::_Solution> pSolution;
		m_pDTE->get_Solution(&pSolution);
		if (!pSolution)
			return S_OK;

		// Look up the DTE.Solution.SolutionBuild object.
		CComPtr<EnvDTE::SolutionBuild> pSolutionBuild;
		pSolution->get_SolutionBuild(&pSolutionBuild);
		if (!pSolutionBuild)
			return S_OK;

		EnvDTE::vsBuildState buildState;
		pSolutionBuild->get_BuildState(&buildState);

		if (buildState == EnvDTE::vsBuildStateInProgress)
			return S_OK;

		if(!_wcsicmp(bstrCmdName, L"FastSolutionBuild.Connect.BuildActiveProject"))
		{
			// Catch any errors.
			try
			{
				BuildActiveProject();
			}
			catch (...)
			{
				::MessageBox(NULL, "The Fast Solution Build add-in was unable to build your project.", "Error", MB_OK);
			}

			// Clear out all of the member variables we might have used.
			if (m_vc70)
			{
				m_projectCompileOrder70.RemoveAll();
			}
			else
			{
				m_projectCompileOrder71.RemoveAll();
			}
			m_projectsProcessed.RemoveAll();
			m_pBuildDependencies = NULL;
			m_pSolutionContexts = NULL;
			m_pSolutionConfiguration = NULL;
			m_pSolutionBuild = NULL;
			m_owPane = NULL;

			*pvbHandled = VARIANT_TRUE;
			return S_OK;
		}

		else if(!_wcsicmp(bstrCmdName, L"FastSolutionBuild.Connect.DebugActiveProject"))
		{
			// Catch any errors.
			try
			{
				EnvDTE::vsIDEMode ideMode;
				m_pDTE->get_Mode(&ideMode);

				if (ideMode != EnvDTE::vsIDEModeDesign)
				{
					m_pDTE->ExecuteCommand(CComBSTR("Debug.Start"), CComBSTR(""));
					return S_OK;
				}

				if (!BuildActiveProject())
				{
					m_pSolutionBuild = NULL;

					DebugActiveProject();
				}
			}
			catch (...)
			{
				::MessageBox(NULL, "The Fast Solution Build add-in was unable to build and run your project.", "Error", MB_OK);
				m_pSolutionBuild = NULL;
			}

			// Clear out all of the member variables we might have used.
			if (m_vc70)
			{
				m_projectCompileOrder70.RemoveAll();
			}
			else
			{
				m_projectCompileOrder71.RemoveAll();
			}
			m_projectsProcessed.RemoveAll();
			m_pBuildDependencies = NULL;
			m_pSolutionContexts = NULL;
			m_pSolutionConfiguration = NULL;
			m_owPane = NULL;

			*pvbHandled = VARIANT_TRUE;
			return S_OK;
		}
	}
	return S_OK;
}
