#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <assert.h>
#include <crtdbg.h>
#include <windows.h>

static BOOL CmdExec(LPCTSTR cmdLine, BOOL closeHandles, HANDLE *processHandle)
{
	STARTUPINFO sinfo;
	memset(&sinfo, 0, sizeof(sinfo));
	sinfo.cb = sizeof(STARTUPINFO);
	sinfo.dwFlags = STARTF_USESHOWWINDOW;
	sinfo.wShowWindow = SW_SHOW;
	PROCESS_INFORMATION pinfo;
	BOOL ret = CreateProcess(NULL, (LPTSTR)cmdLine, NULL, NULL, TRUE, 0,
			NULL, NULL, &sinfo, &pinfo);
	if (closeHandles)
	{
		CloseHandle(pinfo.hProcess);
	}
	if (processHandle != NULL)
		*processHandle = pinfo.hProcess;
	CloseHandle(pinfo.hThread);

	return ret;
}


int _tmain(int argc, _TCHAR* argv[])
{
	printf("Executing Fast Solution Build Redirecting Linker\n");
	fflush(stdout);

	// Retrieve the path and tack a semicolor onto the end of it.
	DWORD pathSize = GetEnvironmentVariable(_T("PATH"), NULL, 0) + 1;
	if (pathSize == 0)
	{
		// There is no PATH environment variable, but we need room to
		// tack the closing ;\0 onto the end.
		pathSize = 2;
	}
	TCHAR* path = new TCHAR[pathSize + 1];
	path[0] = 0;
	GetEnvironmentVariable(_T("PATH"), path, pathSize - 1);
	path[pathSize - 2] = ';';
	path[pathSize - 1] = 0;

	// Get the module name.
	TCHAR moduleName[MAX_PATH];
	moduleName[0] = 0;
	::GetModuleFileName(NULL, (TCHAR*)&moduleName, MAX_PATH);

	// Get the module path.
	TCHAR modulePath[MAX_PATH];
	_tcscpy(modulePath, moduleName);
	TCHAR* slashPtr = _tcsrchr(modulePath, '\\');
	if (!slashPtr)
		slashPtr = _tcsrchr(modulePath, '/');
	*slashPtr++ = 0;

	// In case the path to the custom LINK.exe is in the path, wander through
	// it and remove any references to the path.
	TCHAR* lastSemiPtr = path - 1;
	while (lastSemiPtr != path + pathSize - 2)
	{
		TCHAR* semiPtr = _tcschr(lastSemiPtr + 1, ';');
		TCHAR* startPtr = lastSemiPtr + 1;
		TCHAR* endPtr = semiPtr - 1;
		while (endPtr > lastSemiPtr  &&  (*endPtr == ' '  ||  *endPtr == '\\'  ||  *endPtr == '/'))
			endPtr--;
		endPtr++;

		while (startPtr < endPtr  &&  *startPtr == ' ')
			startPtr++;

		if (_tcsnicmp(startPtr, modulePath, endPtr - startPtr - 1) == 0)
		{
			// Remove it.
			_tcscpy(lastSemiPtr + 1, semiPtr + 1);
			pathSize -= semiPtr - lastSemiPtr;
			semiPtr = lastSemiPtr;
		}

		lastSemiPtr = semiPtr;
	}

	// Search for the path to LINK.exe.
	TCHAR linkPath[MAX_PATH + 1];
	LPTSTR filePart;
	linkPath[0] = 0;
	SearchPath(path, _T("LINK.exe"), NULL, MAX_PATH, linkPath, &filePart);
	size_t linkPathLen = _tcslen(linkPath);

	delete[] path;
	
	// If LINK.exe was not found, or by some coincidence it still found the LINK.exe
	// we launched with, then exit.
	if (linkPathLen == 0)
	{
		printf("LINK.exe not found.\n");
		exit(-1);
	}

	if (_tcsicmp(linkPath, argv[0]) == 0)
	{
		printf("Only this stub LINK.exe was found in the PATH.\n");
		exit(-1);
	}

	// Get any additional data to add on the link command line.
	TCHAR linkResponseFile[MAX_PATH + 1];
	linkResponseFile[0] = '"';
	GetEnvironmentVariable(_T("FSB_LINK"), linkResponseFile + 1, MAX_PATH);
	size_t linkResponseFileLen = _tcslen(linkResponseFile + 1);
	linkResponseFile[linkResponseFileLen + 1] = '"';
	linkResponseFile[linkResponseFileLen + 2] = 0;
	linkResponseFileLen += 2;

	// For now, print the command line so we can see what is going on.
	TCHAR* processCommandLine = GetCommandLine();
	
	// Remove the executable name from the process command line.
	size_t processCommandLineLen = _tcslen(processCommandLine);
	TCHAR* endPtr = NULL;
	if (processCommandLine[0] == '"')
	{
		endPtr = _tcschr(processCommandLine + 1, '"');
		if (!endPtr)
		{
			// Something is whacked.  :(  Look for a space.
		}
		else
		{
			endPtr++;
		}
	}

	if (!endPtr)
	{
		endPtr = _tcschr(processCommandLine, ' ');
	}

	if (!endPtr)
		endPtr = processCommandLine + processCommandLineLen;
	processCommandLineLen -= endPtr - processCommandLine;

	// Allocate space for the new LINK.exe command line.
	TCHAR* commandLine = new TCHAR[linkPathLen + 1 + linkResponseFileLen + 1 + processCommandLineLen + 1];
	
	// Copy the new LINK.exe command line into the newly allocated space.
	TCHAR* ptr = commandLine;
	_tcsncpy(ptr, linkPath, linkPathLen);
	ptr += linkPathLen;
	*ptr++ = ' ';
	_tcsncpy(ptr, linkResponseFile, linkResponseFileLen);
	ptr += linkResponseFileLen;
	*ptr++ = ' ';
	_tcsncpy(ptr, endPtr + 1, processCommandLineLen);
	ptr += processCommandLineLen;
	*ptr = 0;

//	printf("%s\n", commandLine);
//	fflush(stdout);

	// Execute LINK.exe, but wait for it to finish.
	HANDLE processHandle;
	CmdExec(commandLine, FALSE, &processHandle);
	WaitForSingleObject(processHandle, INFINITE);
	CloseHandle(processHandle);

	// Destroy the command line memory.
	delete[] commandLine;

	return 0;
}

